/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.browser.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.openjdk.jmc.browser.JVMBrowserPlugin;
import org.openjdk.jmc.browser.views.BrowserLabelProvider;
import org.openjdk.jmc.browser.views.Folder;
import org.openjdk.jmc.browser.wizards.Messages;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.servermodel.internal.Server;
import org.openjdk.jmc.rjmx.servermodel.internal.ServerModel;
import org.openjdk.jmc.ui.common.util.StatusFactory;
import org.openjdk.jmc.ui.misc.TreeStructureContentProvider;
import org.openjdk.jmc.ui.wizards.ExportTreeToFileWizardPage;
import org.w3c.dom.Document;

public class ConnectionExportWizard
extends Wizard
implements IExportWizard {
    private final ServerModel model = (ServerModel)RJMXPlugin.getDefault().getService(ServerModel.class);
    private ExportConnectionsToFile m_wizardPage;

    public boolean performFinish() {
        if (this.m_wizardPage.isExportToFileOk()) {
            try {
                Server[] servers = this.filterOutNodes(this.m_wizardPage.getSelectedItems());
                XmlToolkit.storeDocumentToFile((Document)this.model.exportServers(servers), (File)this.m_wizardPage.getFile());
                this.m_wizardPage.storeFilename();
                return true;
            }
            catch (Exception e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ConnectionExportWizard_EXPORT_FILE_ERROR_TITLE, (String)(Messages.ConnectionExportWizard_FILE_ERROR_EXPORT_TEXT + "\n\n" + String.valueOf(this.m_wizardPage.getFile())), (IStatus)StatusFactory.createErr((String)e.getMessage(), (Throwable)e, (boolean)true));
            }
        }
        return false;
    }

    protected Server[] filterOutNodes(Collection<?> collection) {
        ArrayList<Server> servers = new ArrayList<Server>();
        for (Object next : collection) {
            if (!(next instanceof Server)) continue;
            servers.add((Server)next);
        }
        return servers.toArray(new Server[servers.size()]);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(JVMBrowserPlugin.getDefault().getDialogSettings());
        this.m_wizardPage = new ExportConnectionsToFile(Messages.ConnectionExportWizard_EXPORT_CONNECTIONS_WIZARD_PAGE_NAME);
        this.m_wizardPage.setTitle(Messages.ConnectionExportWizard_EXPORT_CONNECTIONS_TITLE);
        this.m_wizardPage.setMessage(Messages.ConnectionExportWizard_SELECTIONCONNECTIONS_TO_EXPORT);
        this.m_wizardPage.setImageDescriptor(JVMBrowserPlugin.getDefault().getMCImageDescriptor("bannerconwiz.gif"));
        this.setWindowTitle(Messages.ConnectionExportWizard_WIZARD_EXPORT_CONNECTION_TITLE);
        this.addPage((IWizardPage)this.m_wizardPage);
    }

    public boolean canFinish() {
        return this.m_wizardPage != null && this.m_wizardPage.isPageComplete();
    }

    private class ExportConnectionsToFile
    extends ExportTreeToFileWizardPage {
        private ExportConnectionsToFile(String pageName) {
            super(pageName, "xml");
        }

        protected void initializeViewer(TreeViewer viewer) {
            viewer.setAutoExpandLevel(2);
            viewer.setContentProvider((IContentProvider)new TreeStructureContentProvider());
            Folder root = new Folder(null, "root");
            Server[] serverArray = ConnectionExportWizard.this.model.elements();
            int n = serverArray.length;
            int n2 = 0;
            while (n2 < n) {
                Server server = serverArray[n2];
                if (server.getDiscoveryInfo() == null) {
                    root.getFolder(server.getPath()).addLeaf(server);
                }
                ++n2;
            }
            viewer.setInput((Object)root);
            viewer.setLabelProvider((IBaseLabelProvider)new BrowserLabelProvider());
        }
    }
}

