/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.commands.internal.parser;

import java.text.ParseException;
import org.openjdk.jmc.commands.Parameter;
import org.openjdk.jmc.commands.Token;
import org.openjdk.jmc.commands.internal.parser.ParameterParser;
import org.openjdk.jmc.commands.internal.parser.ParserException;

final class NumberParser
extends ParameterParser {
    public static final String ID = "number";

    public NumberParser(Parameter parameter) {
        super(parameter);
    }

    @Override
    boolean acceptValue(String text) {
        try {
            Double.parseDouble(text);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    @Override
    protected Object parseValue(Token parameterToken, String text) throws ParseException {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParserException("Not a valid number.", parameterToken);
        }
    }
}

