/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.mbeanbrowser.notifications;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class NotificationsModel {
    private final ObjectName m_objectName;
    private final NotificationListener m_notificationListener;
    private final MBeanServerConnection m_mbeanServer;
    private final MBeanInfo m_info;
    private final List<Notification> m_notificationList = new ArrayList<Notification>();
    private final Consumer<? super NotificationsModel> m_observer;
    private boolean m_enabled;

    public NotificationsModel(ObjectName objectName, MBeanServerConnection mbeanServer, Consumer<? super NotificationsModel> observer) throws Exception {
        this.m_objectName = objectName;
        this.m_observer = observer;
        this.m_info = mbeanServer.getMBeanInfo(objectName);
        this.m_mbeanServer = mbeanServer;
        this.m_notificationListener = new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object handback) {
                List<Notification> list = NotificationsModel.this.m_notificationList;
                synchronized (list) {
                    NotificationsModel.this.m_notificationList.add(notification);
                }
                NotificationsModel.this.notifyObserver();
            }
        };
    }

    public ObjectName getObjectName() {
        return this.m_objectName;
    }

    private void notifyObserver() {
        this.m_observer.accept(this);
    }

    public boolean supportsSubscriptions() {
        return this.m_info != null && this.m_info.getNotifications().length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<Notification> getNotifications() {
        List<Notification> list = this.m_notificationList;
        synchronized (list) {
            return Stream.of(this.m_notificationList.toArray(new Notification[this.m_notificationList.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubscriptionEnabled(boolean enable) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        List<Notification> list = this.m_notificationList;
        synchronized (list) {
            if (this.m_enabled != enable) {
                if (enable) {
                    this.getMBeanServerConnection().addNotificationListener(this.m_objectName, this.m_notificationListener, null, null);
                } else {
                    this.getMBeanServerConnection().removeNotificationListener(this.m_objectName, this.m_notificationListener, null, null);
                }
                this.m_enabled = enable;
            }
        }
        this.notifyObserver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSubscriptionEnabled() {
        List<Notification> list = this.m_notificationList;
        synchronized (list) {
            return this.m_enabled;
        }
    }

    public MBeanInfo getMBeanNoticationInfo() {
        return this.m_info;
    }

    private MBeanServerConnection getMBeanServerConnection() {
        return this.m_mbeanServer;
    }

    public void dispose() {
        if (this.getSubscriptionEnabled()) {
            try {
                this.setSubscriptionEnabled(false);
            }
            catch (Exception exception) {}
        }
    }
}

