/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.mbeanbrowser.tab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Stream;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.openjdk.jmc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import org.openjdk.jmc.console.ui.mbeanbrowser.metadata.ConstructorSectionPart;
import org.openjdk.jmc.console.ui.mbeanbrowser.metadata.ItemSectionPart;
import org.openjdk.jmc.console.ui.mbeanbrowser.metadata.MetadataModel;
import org.openjdk.jmc.console.ui.mbeanbrowser.notifications.MBeanNotificationLogInspector;
import org.openjdk.jmc.console.ui.mbeanbrowser.notifications.NotificationInfoSectionPart;
import org.openjdk.jmc.console.ui.mbeanbrowser.notifications.NotificationsModel;
import org.openjdk.jmc.console.ui.mbeanbrowser.tab.Messages;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.internal.RJMXConnection;
import org.openjdk.jmc.rjmx.common.subscription.IMBeanHelperService;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.ui.attributes.MRIAttribute;
import org.openjdk.jmc.rjmx.ui.attributes.MRIAttributeInspector;
import org.openjdk.jmc.rjmx.ui.internal.MBeanPropertiesOrderer;
import org.openjdk.jmc.rjmx.ui.internal.SectionPartManager;
import org.openjdk.jmc.rjmx.ui.operations.ExecuteOperationForm;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.openjdk.jmc.ui.misc.MCLayoutFactory;
import org.openjdk.jmc.ui.misc.MCSectionPart;

public class FeatureSectionPart
extends MCSectionPart {
    private static final String ATTRIBUTES_ID = "attributes";
    private static final String OPERATIONS_ID = "operations";
    private static final String NOTIFICATIONS_ID = "notifications";
    private static final String MBEAN_INFO_ID = "mbeanInfo";
    private static final String CONSTRUCTORS_ID = "constructors";
    private final Map<ObjectName, NotificationsModel> m_notificationModels = new HashMap<ObjectName, NotificationsModel>();
    private final MRIAttributeInspector attributeInspector;
    private final ExecuteOperationForm operationsPart;
    private final NotificationInfoSectionPart notificationsList;
    private final MBeanNotificationLogInspector notificationInspector;
    private final ItemSectionPart mbeanInfoPart;
    private final ConstructorSectionPart constructorsPart;
    private final IConnectionHandle ch;
    private volatile ObjectName lastName;

    public FeatureSectionPart(Composite parent, FormToolkit toolkit, IMemento state, IConnectionHandle ch, SectionPartManager spm) {
        super(parent, toolkit, 256);
        this.ch = ch;
        this.getSection().setText(Messages.FeatureSectionPart_MBEAN_FEATURES_TITLE_TEXT);
        Composite body = this.createSectionBody(MCLayoutFactory.createMarginFreeFormPageLayout());
        CTabFolder tabFolder = new CTabFolder(body, 0);
        toolkit.adapt((Composite)tabFolder);
        tabFolder.setLayoutData(MCLayoutFactory.createFormPageLayoutData());
        CTabItem attributeTab = new CTabItem(tabFolder, 0);
        IMemento aiState = state == null ? null : state.getChild(ATTRIBUTES_ID);
        this.attributeInspector = new MRIAttributeInspector(spm, (Composite)tabFolder, aiState, ch, false, new IColumn[0]);
        attributeTab.setControl((Control)this.attributeInspector.getViewer().getTree());
        attributeTab.setText(Messages.FeatureSectionPart_ATTRIBUTES_TAB_TITLE_TEXT);
        CTabItem operationsTab = new CTabItem(tabFolder, 0);
        IMemento operationsState = state == null ? null : state.getChild(OPERATIONS_ID);
        SashForm sash = new SashForm((Composite)tabFolder, 512);
        this.operationsPart = new ExecuteOperationForm(sash, toolkit, true, operationsState);
        operationsTab.setControl((Control)sash);
        operationsTab.setText(Messages.FeatureSectionPart_OPERATIONS_TAB_TITLE_TEXT);
        CTabItem notificationsTab = new CTabItem(tabFolder, 0);
        SashForm notificationsSash = new SashForm((Composite)tabFolder, 512);
        this.notificationsList = new NotificationInfoSectionPart((Composite)notificationsSash, toolkit, ch);
        IMemento niState = state == null ? null : state.getChild(NOTIFICATIONS_ID);
        this.notificationInspector = new MBeanNotificationLogInspector((Composite)notificationsSash, toolkit, niState);
        notificationsSash.setWeights(new int[]{1, 3});
        notificationsTab.setControl((Control)notificationsSash);
        notificationsTab.setText(Messages.FeatureSectionPart_NOTIFICATIONS_TAB_TITLE_TEXT);
        CTabItem metadataTab = new CTabItem(tabFolder, 0);
        SashForm metadataSash = new SashForm((Composite)tabFolder, 512);
        this.mbeanInfoPart = new ItemSectionPart((Composite)metadataSash, toolkit, state == null ? null : state.getChild(MBEAN_INFO_ID));
        this.constructorsPart = new ConstructorSectionPart((Composite)metadataSash, toolkit, state == null ? null : state.getChild(CONSTRUCTORS_ID));
        metadataTab.setControl((Control)metadataSash);
        metadataTab.setText(Messages.FeatureSectionPart_INFORMATION_TAB_TITLE_TEXT);
        MBeanPropertiesOrderer.addPropertiesOrderChangedListener((MBeanPropertiesOrderer.IMBeanPropertiesOrderChangedListener)this.mbeanInfoPart);
        tabFolder.setSelection(0);
    }

    public void saveState(IMemento state) {
        this.attributeInspector.saveState(state.createChild(ATTRIBUTES_ID));
        this.operationsPart.saveState(state.createChild(OPERATIONS_ID));
        this.notificationInspector.saveState(state.createChild(NOTIFICATIONS_ID));
        this.mbeanInfoPart.saveState(state.createChild(MBEAN_INFO_ID));
        this.constructorsPart.saveState(state.createChild(CONSTRUCTORS_ID));
    }

    public void dispose() {
        this.m_notificationModels.values().forEach(NotificationsModel::dispose);
        MBeanPropertiesOrderer.removePropertiesOrderChangedListener((MBeanPropertiesOrderer.IMBeanPropertiesOrderChangedListener)this.mbeanInfoPart);
        super.dispose();
    }

    public void showBean(ObjectName bean) {
        if (this.lastName != null && this.lastName.equals(bean)) {
            return;
        }
        this.lastName = bean;
        try {
            MBeanInfo info = ((IMBeanHelperService)this.ch.getServiceOrThrow(IMBeanHelperService.class)).getMBeanInfo(bean);
            this.attributeInspector.setInput(this.createMBeanAttributes(bean, info));
            this.operationsPart.setOperations(((RJMXConnection)this.ch.getServiceOrThrow(IMBeanHelperService.class)).getOperations(bean));
            NotificationsModel model = this.getOrCreateNotificationsModel(bean);
            this.notificationsList.setModel(model);
            this.notificationInspector.show(model.getNotifications());
            MetadataModel metadatModel = new MetadataModel(bean, info);
            this.mbeanInfoPart.setModel(metadatModel);
            this.constructorsPart.setMBeanInfo(info);
        }
        catch (Exception e) {
            this.attributeInspector.setInput(Collections.emptyList());
            this.operationsPart.setOperations(Collections.emptyList());
            this.notificationsList.setModel(null);
            this.notificationInspector.show(Stream.empty());
            this.mbeanInfoPart.setModel(null);
            this.constructorsPart.setMBeanInfo(null);
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to load attributes", e);
            String error = Messages.MBeanAttributeSectionPart_FAILED_TO_LOAD_ATTRIBUTES;
            DialogToolkit.showException((Shell)this.getSection().getShell(), (String)error, (String)error, (Throwable)e);
        }
    }

    private void modelUpdated(NotificationsModel model) {
        if (model.getObjectName().equals(this.lastName)) {
            DisplayToolkit.safeAsyncExec(() -> {
                if (model.getObjectName().equals(this.lastName) && DisplayToolkit.isSafe((Widget)this.getSection())) {
                    this.notificationsList.setModel(model);
                    this.notificationInspector.show(model.getNotifications());
                }
            });
        }
    }

    private List<Object> createMBeanAttributes(ObjectName bean, MBeanInfo info) throws Exception {
        ArrayList<Object> attributes = new ArrayList<Object>();
        MBeanAttributeInfo[] mBeanAttributeInfoArray = info.getAttributes();
        int n = mBeanAttributeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanAttributeInfo attribute = mBeanAttributeInfoArray[n2];
            if (attribute.getName() == null) {
                attributes.add(new MRIAttributeInspector.ErroneousAttribute(attribute.getName(), attribute.getType(), attribute.getDescription()));
            } else {
                attributes.add(MRIAttribute.create((IConnectionHandle)this.ch, (MRI)new MRI(MRI.Type.ATTRIBUTE, bean, attribute.getName())));
            }
            ++n2;
        }
        return attributes;
    }

    private NotificationsModel getOrCreateNotificationsModel(ObjectName mbean) throws Exception {
        NotificationsModel model = this.m_notificationModels.get(mbean);
        if (model == null) {
            model = new NotificationsModel(mbean, (MBeanServerConnection)this.ch.getServiceOrThrow(MBeanServerConnection.class), this::modelUpdated);
            this.m_notificationModels.put(mbean, model);
        }
        return model;
    }
}

