/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.model;

import org.openjdk.jmc.console.agent.manager.model.CapturedValue;
import org.openjdk.jmc.console.agent.manager.model.Event;
import org.openjdk.jmc.console.agent.manager.model.IField;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Field
extends CapturedValue
implements IField {
    private static final String DEFAULT_FIELD_NAME = "New Field";
    private static final String DEFAULT_FIELD_EXPRESSION = "myField";
    private static final String EXPRESSION_REGEX = "([a-zA-Z_$][a-zA-Z0-9_$]*\\.)*([a-zA-Z_$][a-zA-Z0-9_$]*)(\\.[a-zA-Z_$][a-zA-Z_$]*)*";
    private static final String XML_TAG_FIELD = "field";
    private static final String XML_TAG_EXPRESSION = "expression";
    private final Event event;
    private String expression;

    Field(Event event) {
        this.event = event;
        this.expression = DEFAULT_FIELD_EXPRESSION;
        this.setName(DEFAULT_FIELD_NAME);
    }

    Field(Event event, Element element) {
        super(element);
        this.event = event;
        NodeList elements = element.getElementsByTagName(XML_TAG_EXPRESSION);
        if (elements.getLength() != 0) {
            this.expression = elements.item(0).getTextContent();
        }
    }

    @Override
    public Element buildElement(Document document) {
        Element element = super.buildElement(document);
        element = (Element)document.renameNode(element, null, XML_TAG_FIELD);
        Element expressionElement = document.createElement(XML_TAG_EXPRESSION);
        expressionElement.setTextContent(this.expression);
        element.appendChild(expressionElement);
        return element;
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(Messages.Field_ERROR_NAME_CANNOT_BE_EMPTY_OR_NULL);
        }
        super.setName(name);
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(String expression) {
        if (expression == null || expression.isEmpty()) {
            throw new IllegalArgumentException(Messages.Field_ERROR_EXPRESSION_CANNOT_BE_EMPTY_OR_NULL);
        }
        if (!(expression = expression.trim()).matches(EXPRESSION_REGEX)) {
            throw new IllegalArgumentException(Messages.Field_ERROR_EXPRESSION_HAS_INCORRECT_SYNTAX);
        }
        this.expression = expression;
    }

    @Override
    public Field createWorkingCopy() {
        Field copy = new Field(this.event);
        this.copyContentToWorkingCopy(copy);
        copy.expression = this.expression;
        return copy;
    }

    @Override
    public Field createDuplicate() {
        Field duplicate = this.createWorkingCopy();
        duplicate.setName(this.event.nextUniqueFieldName(this.getName()));
        return duplicate;
    }
}

