/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules;

import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IItemQuery;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.rules.messages.internal.Messages;

public class TypedResult<T> {
    public static final TypedResult<IQuantity> SCORE = new TypedResult<IQuantity>("score", Messages.getString("TypedResult_SCORE_NAME"), Messages.getString("TypedResult_SCORE_DESCRIPTION"), (ContentType<IQuantity>)UnitLookup.NUMBER, IQuantity.class);
    public static final ContentType<IItemQuery> QUERY = UnitLookup.createSyntheticContentType((String)"itemQuery");
    public static final TypedResult<IItemQuery> ITEM_QUERY = new TypedResult<IItemQuery>("itemQuery", "Item Query", "Relevant items used to evaluate this rule.", QUERY, IItemQuery.class);
    private final String identifier;
    private final String name;
    private final String description;
    private final ContentType<T> contentType;
    private final Class<T> clazz;

    public TypedResult(String identifier, String name, String description, ContentType<T> contentType, Class<T> clazz) {
        this.identifier = identifier;
        this.name = name;
        this.description = description;
        this.contentType = contentType;
        this.clazz = clazz;
    }

    public TypedResult(String identifier, String name, String description, ContentType<T> contentType) {
        this.identifier = identifier;
        this.name = name;
        this.description = description;
        this.contentType = contentType;
        this.clazz = null;
    }

    public TypedResult(String identifier, IAggregator<T, ?> aggregator, ContentType<T> contentType, Class<T> clazz) {
        this.identifier = identifier;
        this.name = aggregator.getName();
        this.description = aggregator.getDescription();
        this.contentType = contentType;
        this.clazz = clazz;
    }

    public Class<T> getResultClass() {
        return this.clazz;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ContentType<T> getPersister() {
        return this.contentType;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public String format(Object result) {
        return this.contentType.getDefaultFormatter().format(this.clazz.cast(result));
    }

    public boolean equals(Object o) {
        if (o instanceof TypedResult) {
            return ((TypedResult)o).identifier.equals(this.identifier);
        }
        return false;
    }

    public String toString() {
        return "[" + this.identifier + ", " + this.description + "]";
    }
}

