/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow;

import java.io.IOException;
import org.openjdk.jmc.joverflow.batch.BatchProblemRecorder;
import org.openjdk.jmc.joverflow.batch.DetailedStats;
import org.openjdk.jmc.joverflow.batch.ReportFormatter;
import org.openjdk.jmc.joverflow.heap.model.Snapshot;
import org.openjdk.jmc.joverflow.heap.parser.DumpCorruptedException;
import org.openjdk.jmc.joverflow.heap.parser.HeapDumpReader;
import org.openjdk.jmc.joverflow.heap.parser.HprofParsingCancelledException;
import org.openjdk.jmc.joverflow.heap.parser.ReadBuffer;
import org.openjdk.jmc.joverflow.stats.StandardStatsCalculator;
import org.openjdk.jmc.joverflow.support.HeapStats;
import org.openjdk.jmc.joverflow.util.FileUtils;
import org.openjdk.jmc.joverflow.util.ProgressMeter;
import org.openjdk.jmc.joverflow.util.VerboseOutputCollector;

public class ReportGenerator {
    private static final boolean DEFAULT_PRINT_FULL_OBJ_HISTO = false;
    private static final int DEFAULT_PRINTED_REF_CHAIN_DEPTH = 8;
    private static final String[] DEFAULT_REF_CHAIN_STOPPER_CLASS_PREFIXES = new String[]{"oracle.apps."};
    private ReportFormatter reportFormatter;
    private volatile HeapDumpReader reader;
    private volatile StandardStatsCalculator ssc;

    public static ReportGenerator parseDump(String hprofFile, Progress progress, boolean useBreadthFirstScan) throws IOException, DumpCorruptedException, HprofParsingCancelledException {
        FileUtils.checkFileExistsAndReadable(hprofFile, false);
        return new ReportGenerator(hprofFile, progress, useBreadthFirstScan);
    }

    public String getReport() {
        return this.getReport(false, 8, DEFAULT_REF_CHAIN_STOPPER_CLASS_PREFIXES);
    }

    public String getReport(boolean printFullClassHistogram, int printedRefChainDepth, String[] refChainStopperClassPrefixes) {
        return this.reportFormatter.getReport(printFullClassHistogram, printedRefChainDepth, refChainStopperClassPrefixes);
    }

    private ReportGenerator(String hprofFile, Progress progress, boolean useBreadthFirstScan) throws IOException, DumpCorruptedException, HprofParsingCancelledException {
        CallbackProgressMeter pm = null;
        if (progress != null) {
            progress.setReportGenerator(this);
            pm = new CallbackProgressMeter(progress);
            pm.start();
        }
        Snapshot snapshot = this.readSnapshot(hprofFile);
        BatchProblemRecorder recorder = new BatchProblemRecorder();
        this.ssc = new StandardStatsCalculator(snapshot, recorder, useBreadthFirstScan);
        HeapStats hs = this.ssc.calculate();
        this.ssc = null;
        int minOvhdToReport = (int)hs.totalObjSize / 1000;
        DetailedStats ds = recorder.getDetailedStats(minOvhdToReport);
        if (pm != null) {
            pm.stopReporting();
        }
        this.reportFormatter = new ReportFormatter(hs, ds);
    }

    private Snapshot readSnapshot(String fileName) throws IOException, DumpCorruptedException, HprofParsingCancelledException {
        VerboseOutputCollector vc = new VerboseOutputCollector();
        this.reader = HeapDumpReader.createReader(new ReadBuffer.CachedReadBufferFactory(fileName, 0), 0, vc);
        Snapshot snapshot = this.reader.read();
        this.reader = null;
        return snapshot;
    }

    private class CallbackProgressMeter
    extends ProgressMeter {
        private final Progress pc;
        private int prevReadPercent;
        private int prevAnalyzePercent;

        CallbackProgressMeter(Progress pc) {
            this.pc = pc;
        }

        @Override
        public int queryPercentage() {
            int readPercent = this.prevReadPercent;
            int analyzePercent = this.prevAnalyzePercent;
            HeapDumpReader localReader = ReportGenerator.this.reader;
            if (localReader != null) {
                this.prevReadPercent = readPercent = localReader.getProgressPercentage();
            } else if (this.prevReadPercent > 0) {
                readPercent = 100;
            }
            StandardStatsCalculator localSsc = ReportGenerator.this.ssc;
            if (localSsc != null) {
                this.prevAnalyzePercent = analyzePercent = localSsc.getProgressPercentage();
            }
            return readPercent / 3 + analyzePercent * 2 / 3;
        }

        @Override
        public void reportProgress(int progressPerecentage) {
            this.pc.reportProgress(progressPerecentage);
        }
    }

    public static abstract class Progress {
        private ReportGenerator rg;

        public abstract void reportProgress(int var1);

        public void cancel() {
            StandardStatsCalculator localSsc;
            ReportGenerator localRg = this.rg;
            if (localRg == null) {
                return;
            }
            HeapDumpReader localReader = localRg.reader;
            if (localReader != null) {
                localReader.cancelReading();
            }
            if ((localSsc = localRg.ssc) != null) {
                localSsc.cancelCalculation();
            }
        }

        private void setReportGenerator(ReportGenerator rg) {
            this.rg = rg;
        }
    }
}

