/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.util.jmx;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;

public class SingleMBeanServerAccess
implements MBeanServerAccess {
    private final MBeanServerConnection connection;

    public SingleMBeanServerAccess(MBeanServerConnection pConnection) {
        this.connection = pConnection;
    }

    @Override
    public void each(ObjectName pObjectName, MBeanServerAccess.MBeanEachCallback pCallback) throws IOException, ReflectionException, MBeanException {
        try {
            for (ObjectName nameObject : this.connection.queryNames(pObjectName, null)) {
                pCallback.callback(this.connection, nameObject);
            }
        }
        catch (InstanceNotFoundException exp) {
            throw new IllegalArgumentException("Cannot find MBean " + (String)(pObjectName != null ? "(MBean " + pObjectName + ")" : "") + ": " + exp, exp);
        }
    }

    @Override
    public <R> R call(ObjectName pObjectName, MBeanServerAccess.MBeanAction<R> pMBeanAction, Object ... pExtraArgs) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        return pMBeanAction.execute(this.connection, pObjectName, pExtraArgs);
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName pObjectName) throws IOException {
        return this.connection.queryNames(pObjectName, null);
    }

    public void destroy() {
    }

    @Override
    public boolean hasMBeansListChangedSince(long pTimestamp) {
        return true;
    }

    @Override
    public Set<MBeanServerConnection> getMBeanServers() {
        return Collections.singleton(this.connection);
    }
}

