/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.wizards;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.openjdk.jmc.ui.misc.DialogToolkit;
import org.openjdk.jmc.ui.misc.FileSelector;
import org.openjdk.jmc.ui.wizards.Messages;

public abstract class ExportToFileWizardPage
extends WizardPage {
    private static final String DIALOG_SETTINGS_NAME = "export.to.file.wizard.settings";
    private static final String OVERWRITE_OK = "overwrite.earning.check";
    private final String m_fileExtension;
    private final String m_defaultFileName;
    private IDialogSettings m_exportSettings;
    private FileSelector m_fileSelector;

    public ExportToFileWizardPage(String pageName, String fileExtension, String defaultFileName) {
        super(pageName);
        this.m_fileExtension = fileExtension;
        this.m_defaultFileName = defaultFileName;
    }

    public ExportToFileWizardPage(String pageName, String fileExtension) {
        this(pageName, fileExtension, null);
    }

    public boolean isExportToFileOk() {
        if (!this.isOverwriteOK() && this.getFile() != null && this.getFile().exists()) {
            return DialogToolkit.openQuestionOnUiThread(Messages.ExportToFileWizardPage_OVERWRITE_QUESTION_TITLE, MessageFormat.format(Messages.ExportToFileWizardPage_OVERWRITE_QUESTION_TEXT, this.getFile().getAbsolutePath()));
        }
        return true;
    }

    public void createControl(Composite parent) {
        this.m_exportSettings = DialogSettings.getOrCreateSection((IDialogSettings)this.getDialogSettings(), (String)DIALOG_SETTINGS_NAME);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Composite contents = this.createContents(container);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        Control fileSelector = this.createFileSelector(container);
        fileSelector.setLayoutData((Object)new GridData(4, 4, true, false));
        this.setControl((Control)container);
    }

    protected abstract Composite createContents(Composite var1);

    private Control createFileSelector(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridData fileSectionGridData = new GridData(4, 4, true, false);
        this.m_fileSelector = new FileSelector(container, this.m_exportSettings, Messages.ExportToFileWizardPage_EXPORT_TO_FILE, false, 8192, this.m_defaultFileName, this.m_fileExtension);
        this.m_fileSelector.setLayoutData(fileSectionGridData);
        this.m_fileSelector.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("no.file.specified".equals(event.getProperty())) {
                    ExportToFileWizardPage.this.setMessage((String)event.getNewValue());
                    ExportToFileWizardPage.this.setErrorMessage(null);
                    ExportToFileWizardPage.this.setPageComplete(false);
                }
                if ("directory.does.not.exist".equals(event.getProperty())) {
                    ExportToFileWizardPage.this.setErrorMessage((String)event.getNewValue());
                    ExportToFileWizardPage.this.setMessage(null);
                    ExportToFileWizardPage.this.setPageComplete(false);
                }
                if ("valid.file.name.specified".equals(event.getProperty())) {
                    ExportToFileWizardPage.this.setMessage(Messages.ExportToFileWizardPage_CLICK_FINISH_MESSAGE_TEXT);
                    ExportToFileWizardPage.this.setErrorMessage(null);
                    ExportToFileWizardPage.this.updatePageComplete();
                }
            }
        });
        GridData overWriteCheckGridData = new GridData(4, 4, true, false);
        Control overWriteontrol = this.createOvewriteWarningCheckbox(container);
        overWriteontrol.setLayoutData((Object)overWriteCheckGridData);
        return container;
    }

    protected void updatePageComplete() {
        this.setPageComplete(this.isPageComplete());
    }

    private Control createOvewriteWarningCheckbox(Composite container) {
        final Button button = new Button(container, 32);
        button.setText(Messages.ExportToFileWizardPage_WARN_IF_OVERWRITE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!button.isDisposed()) {
                    ExportToFileWizardPage.this.setOverwriteOK(!button.getSelection());
                }
            }
        });
        button.setSelection(!this.m_exportSettings.getBoolean(OVERWRITE_OK));
        return button;
    }

    private boolean isOverwriteOK() {
        return this.m_exportSettings.getBoolean(OVERWRITE_OK);
    }

    private void setOverwriteOK(boolean overwrite) {
        this.m_exportSettings.put(OVERWRITE_OK, overwrite);
    }

    public boolean isPageComplete() {
        if (this.getFile() != null) {
            if (!this.isSelectionValid()) {
                this.setMessage(Messages.ExportToFileWizardPage_SELECT_ITEMS);
                return false;
            }
            this.setMessage(Messages.ExportToFileWizardPage_CLICK_FINISH_MESSAGE_TEXT);
            return true;
        }
        return false;
    }

    protected abstract boolean isSelectionValid();

    public File getFile() {
        if (this.m_fileSelector != null && !this.m_fileSelector.isDisposed()) {
            return this.m_fileSelector.getFile();
        }
        return null;
    }

    public void storeFilename() {
        this.m_fileSelector.storeFilename();
    }
}

