/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.unit;

import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.UnitLookup;

public class QuantitiesToolkit {
    private static final ITypedQuantity<LinearUnit> ZERO = UnitLookup.NUMBER_UNITY.quantity(0L);

    public static <M extends Comparable<? super M>> M min(M a, M b) {
        return a.compareTo(b) < 0 ? a : b;
    }

    public static <M extends Comparable<? super M>> M max(M a, M b) {
        return a.compareTo(b) > 0 ? a : b;
    }

    public static <M extends Comparable<? super M>> M minPresent(M a, M b) {
        return a == null ? b : (b == null ? a : QuantitiesToolkit.min(a, b));
    }

    public static <M extends Comparable<? super M>> M maxPresent(M a, M b) {
        return a == null ? b : (b == null ? a : QuantitiesToolkit.max(a, b));
    }

    public static <M extends Comparable<? super M>> boolean same(M a, M b) {
        return a == null ? b == null : (b == null ? false : a.compareTo(b) == 0);
    }

    public static IQuantity nullSafe(IQuantity quantity) {
        if (quantity != null) {
            return quantity;
        }
        return ZERO;
    }
}

