/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rcp.application;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.ui.common.CorePlugin;
import org.openjdk.jmc.ui.common.resource.MCFile;

class BasicFile
implements MCFile {
    private final String path;

    BasicFile(String file) {
        this.path = file;
    }

    public String toString() {
        return this.path;
    }

    public void writeStream(InputStream stream, IProgressMonitor monitor, boolean append) throws IOException {
        File f = BasicFile.makeAbsolute(this.path);
        BasicFile.write(stream, f, append);
    }

    public boolean tryWriteStream(InputStream stream, IProgressMonitor monitor) throws IOException {
        File f = BasicFile.makeAbsolute(this.path);
        if (f.exists()) {
            return false;
        }
        BasicFile.write(stream, f, false);
        return true;
    }

    private static void write(InputStream in, File toOutput, boolean append) throws IOException {
        File parent = toOutput.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException();
        }
        IOToolkit.write((InputStream)in, (File)toOutput, (boolean)append);
    }

    public String getPath() {
        return this.path;
    }

    public static File makeAbsolute(String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(CorePlugin.getDefault().getWorkspaceDirectory(), path);
    }
}

