/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph;

import io.github.bric3.fireplace.core.ui.Colors;
import io.github.bric3.fireplace.flamegraph.FrameBox;
import io.github.bric3.fireplace.flamegraph.FrameRenderingFlags;
import java.awt.Color;
import java.util.Objects;
import java.util.function.Function;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface FrameColorProvider<T> {
    @NotNull
    public ColorModel getColors(@NotNull @NotNull FrameBox<@NotNull T> var1, int var2);

    @NotNull
    public static <T> @NotNull FrameColorProvider<@NotNull T> defaultColorProvider(final @NotNull @NotNull Function<@NotNull FrameBox<@NotNull T>, @NotNull Color> frameBaseColorFunction) {
        Objects.requireNonNull(frameBaseColorFunction, "frameColorFunction");
        return new FrameColorProvider<T>(){
            private final Color highlightedColor = new Color(-6287, true);
            private final ColorModel reusableDataStructure = new ColorModel();

            @Override
            @NotNull
            public ColorModel getColors(@NotNull @NotNull FrameBox<@NotNull T> frame, int flags) {
                Color baseBackgroundColor;
                Color backgroundColor = baseBackgroundColor = (Color)frameBaseColorFunction.apply(frame);
                if (FrameRenderingFlags.isFocusing(flags) && !FrameRenderingFlags.isFocusedFrame(flags)) {
                    backgroundColor = Colors.blend(baseBackgroundColor, Colors.translucent_black_80);
                }
                if (FrameRenderingFlags.isHighlighting(flags)) {
                    Color color = backgroundColor = Colors.isDarkMode() ? Colors.blend(backgroundColor, Colors.translucent_black_B0) : Colors.blend(backgroundColor, Color.WHITE);
                    if (FrameRenderingFlags.isHighlightedFrame(flags)) {
                        backgroundColor = baseBackgroundColor;
                    }
                }
                if (FrameRenderingFlags.isHovered(flags)) {
                    backgroundColor = Colors.blend(backgroundColor, Colors.translucent_black_40);
                }
                return this.reusableDataStructure.set(backgroundColor, Colors.foregroundColor(backgroundColor));
            }
        };
    }

    public static class ColorModel {
        public static Color DEFAULT_FRAME_BACKGROUND_COLOR = UIManager.getColor("Button.background");
        public static Color DEFAULT_FRAME_FOREGROUND_COLOR = UIManager.getColor("Button.foreground");
        @NotNull
        public Color background;
        @NotNull
        public Color foreground;

        public ColorModel() {
            this(DEFAULT_FRAME_BACKGROUND_COLOR, DEFAULT_FRAME_FOREGROUND_COLOR);
        }

        public ColorModel(@NotNull Color background, @NotNull Color foreground) {
            this.background = background;
            this.foreground = foreground;
        }

        @NotNull
        public ColorModel set(@NotNull Color background, @NotNull Color foreground) {
            this.background = background;
            this.foreground = foreground;
            return this;
        }

        public ColorModel copy() {
            return new ColorModel(this.background, this.foreground);
        }
    }
}

