/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.column;

import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.openjdk.jmc.ui.column.ColumnManager;
import org.openjdk.jmc.ui.column.CopyColumnsAction;
import org.openjdk.jmc.ui.column.IColumn;
import org.openjdk.jmc.ui.column.Messages;
import org.openjdk.jmc.ui.handlers.InFocusHandlerActivator;
import org.openjdk.jmc.ui.handlers.MCContextMenuManager;
import org.openjdk.jmc.ui.misc.CopySettings;

public class ColumnMenusFactory {
    public static void addDefaultMenus(ColumnManager columnManager, MCContextMenuManager manager) {
        manager.appendToGroup("group.viewerSetup", (IContributionItem)ColumnMenusFactory.sortMenu(columnManager));
        manager.appendToGroup("group.viewerSetup", (IContributionItem)ColumnMenusFactory.visibilityMenu(columnManager));
        Function<Boolean, Stream<? extends IColumn>> columns = onlyVisible -> ColumnMenusFactory.getColumns(onlyVisible, columnManager.getColumnStates());
        IAction copyColumnsAction = CopyColumnsAction.build((StructuredViewer)columnManager.getViewer(), columns);
        manager.appendToGroup("group.edit", copyColumnsAction);
        InFocusHandlerActivator.install(columnManager.getViewer().getControl(), copyColumnsAction);
        manager.appendToGroup("group.edit", CopySettings.getInstance().createContributionItem());
    }

    private static Stream<? extends IColumn> getColumns(Boolean onlyVisible, Stream<? extends ColumnManager.IColumnState> columnStates) {
        if (onlyVisible.booleanValue()) {
            columnStates = columnStates.filter(ColumnManager.IColumnState::isVisible);
        }
        return columnStates.map(ColumnManager.IColumnState::getColumn);
    }

    public static MenuManager visibilityMenu(final ColumnManager columnManager) {
        MenuManager menu = new MenuManager(Messages.VISIBILE_COLUMNS_MENU_HEADER);
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener(new IMenuListener(){
            private Action checked = null;
            private int checkedCount = 0;

            public void menuAboutToShow(IMenuManager manager) {
                this.checked = null;
                this.checkedCount = 0;
                columnManager.getColumnStates().map(this::createVisibilityAction).forEach(arg_0 -> ((IMenuManager)manager).add(arg_0));
                if (this.checkedCount == 1 && this.checked != null) {
                    this.checked.setEnabled(false);
                }
            }

            private Action createVisibilityAction(final ColumnManager.IColumnState state) {
                Action a = new Action(state.getColumn().getName(), 2){

                    public void run() {
                        columnManager.setColumnHidden(state.getColumn().getId(), !this.isChecked());
                    }
                };
                if (state.isVisible()) {
                    a.setChecked(true);
                    this.checked = a;
                    ++this.checkedCount;
                }
                return a;
            }
        });
        return menu;
    }

    public static MenuManager sortMenu(final ColumnManager columnManager) {
        MenuManager menu = new MenuManager(Messages.SORT_COLUMNS_MENU_HEADER);
        menu.setRemoveAllWhenShown(true);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)this.createNoSortAction());
                columnManager.getColumnStates().filter(ColumnManager.IColumnState::isVisible).map(ColumnManager.IColumnState::getColumn).map(this::createSortMenu).forEach(arg_0 -> ((IMenuManager)manager).add(arg_0));
            }

            private MenuManager createSortMenu(IColumn column) {
                MenuManager sortColumnMenu = new MenuManager(column.getName(), column.getId());
                sortColumnMenu.add((IAction)this.createSortAction(true, column.getId()));
                sortColumnMenu.add((IAction)this.createSortAction(false, column.getId()));
                return sortColumnMenu;
            }

            private Action createSortAction(final boolean sortAscending, final String columnId) {
                String text = sortAscending ? Messages.SORT_COLUMN_ASCENDING_MENU_ITEM : Messages.SORT_COLUMN_DESCENDING_MENU_ITEM;
                return new Action(text){

                    public void run() {
                        columnManager.setSortColumn(columnId, sortAscending);
                    }
                };
            }

            private Action createNoSortAction() {
                return new Action(Messages.SORT_COLUMN_NONE_MENU_ITEM){

                    public void run() {
                        columnManager.clearSortColumn();
                    }
                };
            }
        });
        return menu;
    }
}

