/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.misc;

import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.ui.misc.QuantityKindProposal;

public class LinearQuantityProposalProvider
implements IContentProposalProvider {
    private static final int BASE_SCORE = 0x3FFFFFFF;
    final Collection<LinearUnit> units;

    public LinearQuantityProposalProvider(LinearKindOfQuantity kind) {
        this.units = kind.getAllUnits();
    }

    public LinearQuantityProposalProvider(LinearUnit unit) {
        Collection allUnits = unit.getContentType().getAllUnits();
        if (!allUnits.contains(unit)) {
            ArrayList<LinearUnit> unitList = new ArrayList<LinearUnit>(allUnits.size() + 1);
            unitList.addAll(allUnits);
            unitList.add(unit);
            unitList.sort(null);
            this.units = unitList;
        } else {
            this.units = allUnits;
        }
    }

    public IContentProposal[] getProposals(String contents, int position) {
        contents = contents.replace('\u00a0', ' ');
        ParsePosition pos = new ParsePosition(0);
        Number num = LinearKindOfQuantity.getNumberFormat((boolean)true).parse(contents, pos);
        ArrayList<QuantityKindProposal.Proposal> proposals = new ArrayList<QuantityKindProposal.Proposal>();
        if (num != null) {
            boolean hasEmptyProposal = false;
            String unitPart = contents.substring(pos.getIndex()).trim();
            for (IUnit iUnit : this.units) {
                int score;
                String symbol = iUnit.getLocalizedSymbol();
                if (unitPart.length() == 0) {
                    if (symbol.length() == 0) {
                        score = Integer.MAX_VALUE;
                        hasEmptyProposal = true;
                    } else {
                        score = 0x3FFFFFFF;
                    }
                } else {
                    score = Math.max(this.matchScore(unitPart, symbol), this.matchScore(unitPart, iUnit.getIdentifier()) - 100);
                    String[] stringArray = iUnit.getAltLocalizedNames();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String unitName = stringArray[n2];
                        score = Math.max(score, this.matchScore(unitPart, unitName));
                        ++n2;
                    }
                }
                if (score <= 0) continue;
                proposals.add(new QuantityKindProposal.Proposal(score, contents.substring(0, pos.getIndex()) + iUnit.getAppendableSuffix(true), symbol, iUnit.getLocalizedDescription()));
            }
            if (proposals.size() == 1 && (hasEmptyProposal || contents.equals(((QuantityKindProposal.Proposal)proposals.get(0)).getContent()))) {
                return new IContentProposal[0];
            }
        }
        Object[] proposalArr = proposals.toArray(new IContentProposal[proposals.size()]);
        Arrays.sort(proposalArr);
        return proposalArr;
    }

    private int matchScore(String partialUnit, String unitName) {
        if (unitName.startsWith(partialUnit)) {
            return 0x3FFFFFFF + partialUnit.length() - unitName.length() + 3;
        }
        if (unitName.toLowerCase(Locale.ENGLISH).startsWith(partialUnit.toLowerCase(Locale.ENGLISH))) {
            return 0x3FFFFFFF + partialUnit.length() - unitName.length();
        }
        return -1073741823;
    }
}

