/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.unit.IQuantity;

public class DisjointBuilder<T> {
    private static final IMemberAccessor<IQuantity, DisjointArray<?>> DA_START = new IMemberAccessor<IQuantity, DisjointArray<?>>(){

        public IQuantity getMember(DisjointArray<?> inObject) {
            return inObject.start;
        }
    };
    private static final IMemberAccessor<IQuantity, DisjointArray<?>> DA_END = new IMemberAccessor<IQuantity, DisjointArray<?>>(){

        public IQuantity getMember(DisjointArray<?> inObject) {
            return inObject.end;
        }
    };
    private int noLanes = 0;
    private DisjointArray<T>[] lanes = new DisjointArray[1];
    private final IMemberAccessor<IQuantity, ? super T> startAccessor;
    private final IMemberAccessor<IQuantity, ? super T> endAccessor;

    public DisjointBuilder(IMemberAccessor<IQuantity, ? super T> startAccessor, IMemberAccessor<IQuantity, ? super T> endAccessor) {
        this.startAccessor = startAccessor;
        this.endAccessor = endAccessor;
    }

    public void add(T e) {
        IQuantity start = (IQuantity)this.startAccessor.getMember(e);
        IQuantity end = ((IQuantity)this.endAccessor.getMember(e)).in(start.getUnit());
        if (this.noLanes == 0) {
            this.addToNewLane(e, start, end);
        } else if (!this.lanes[0].accept(e, start, end)) {
            this.addToOtherLane(e, start, end);
        }
    }

    private int indexOf(IQuantity point, int from, int to) {
        int low = from;
        int high = to - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            DisjointArray<T> lane = this.lanes[mid];
            int comparison = point.compareTo((Object)lane.end);
            if (comparison < 0) {
                low = mid + 1;
                continue;
            }
            if (comparison <= 0) break;
            high = mid - 1;
        }
        return low;
    }

    private void addToOtherLane(T e, IQuantity start, IQuantity end) {
        int modificationIndex = this.indexOf(start, 1, this.noLanes);
        if (modificationIndex < this.noLanes) {
            DisjointArray<T> lane = this.lanes[modificationIndex];
            if (modificationIndex > 0 && this.lanes[modificationIndex - 1].end.compareTo((Object)end) < 0) {
                this.relocateLane(modificationIndex, end, lane);
            }
            lane.extend(e, end);
        } else {
            this.resizeIfNecessary();
            DisjointArray<T> lane = new DisjointArray<T>(e, start, end);
            if (this.lanes[modificationIndex - 1].end.compareTo((Object)end) < 0) {
                this.relocateLane(modificationIndex, end, lane);
            } else {
                this.lanes[modificationIndex] = lane;
            }
            ++this.noLanes;
        }
    }

    private void relocateLane(int modificationIndex, IQuantity end, DisjointArray<T> lane) {
        int relocationIndex = this.indexOf(end, 0, this.noLanes);
        for (int i = modificationIndex; i > relocationIndex; --i) {
            this.lanes[i] = this.lanes[i - 1];
        }
        this.lanes[relocationIndex] = lane;
    }

    private int addToNewLane(T e, IQuantity start, IQuantity end) {
        this.resizeIfNecessary();
        this.lanes[this.noLanes] = new DisjointArray<T>(e, start, end);
        return this.noLanes++;
    }

    private void resizeIfNecessary() {
        if (this.noLanes >= this.lanes.length) {
            this.lanes = Arrays.copyOf(this.lanes, this.lanes.length * 3 / 2 + 2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <U> Collection<U[]> toArrays(Iterable<? extends DisjointBuilder<U>> collections, ArrayFactory<U> arrayFactory) {
        void var5_11;
        ArrayList allLanes = new ArrayList();
        for (DisjointBuilder<U> disjointBuilder : collections) {
            for (int i = 0; i < disjointBuilder.noLanes; ++i) {
                allLanes.add(disjointBuilder.lanes[i]);
            }
        }
        if (allLanes.size() == 0) {
            return Collections.emptyList();
        }
        allLanes.sort(new Comparator<DisjointArray<?>>(){

            @Override
            public int compare(DisjointArray<?> o1, DisjointArray<?> o2) {
                return o1.end.compareTo((Object)o2.end);
            }
        });
        DisjointBuilder lanesCombiner = new DisjointBuilder(DA_START, DA_END);
        for (DisjointArray disjointArray : allLanes) {
            lanesCombiner.add(disjointArray);
        }
        ArrayList<U[]> arrayList = new ArrayList<U[]>(lanesCombiner.noLanes);
        boolean bl = false;
        while (var5_11 < lanesCombiner.noLanes) {
            DisjointArray laneOfLanes = lanesCombiner.lanes[var5_11];
            int totalSize = 0;
            for (int j = 0; j < laneOfLanes.size; ++j) {
                DisjointArray lane = (DisjointArray)laneOfLanes.getElement(j);
                totalSize += lane.size;
            }
            U[] resultArray = arrayFactory.createArray(totalSize);
            int offset = 0;
            for (int j = 0; j < laneOfLanes.size; ++j) {
                DisjointArray lane = (DisjointArray)laneOfLanes.getElement(j);
                System.arraycopy(lane.array, 0, resultArray, offset, lane.size);
                offset += lane.size;
            }
            arrayList.add(resultArray);
            ++var5_11;
        }
        return arrayList;
    }

    private static class DisjointArray<T> {
        private Object[] array = new Object[3];
        final IQuantity start;
        IQuantity end;
        int size = 0;

        DisjointArray(T e, IQuantity start, IQuantity end) {
            this.start = start;
            this.end = end;
            this.array[this.size++] = e;
        }

        boolean accept(T e, IQuantity start, IQuantity end) {
            if (start.compareTo((Object)this.end) >= 0) {
                this.extend(e, end);
                return true;
            }
            return false;
        }

        void extend(T e, IQuantity end) {
            if (this.size >= this.array.length) {
                int newCapacity = this.array.length < 100 ? this.array.length * 4 : this.array.length * 3 / 2 + 1;
                this.array = Arrays.copyOf(this.array, newCapacity);
            }
            this.array[this.size++] = e;
            this.end = end;
        }

        private T getElement(int index) {
            Object t = this.array[index];
            return (T)t;
        }
    }

    public static interface ArrayFactory<U> {
        public U[] createArray(int var1);
    }
}

