/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.configuration.recording;

import java.util.Date;
import java.util.Properties;
import org.openjdk.jmc.common.unit.IConstrainedMap;
import org.openjdk.jmc.common.unit.IMutableConstrainedMap;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.configuration.IRecorderConfigurationService;
import org.openjdk.jmc.flightrecorder.configuration.internal.ValidationToolkit;

public class RecordingOptionsBuilder {
    public static final String KEY_NAME = "name";
    public static final String KEY_DURATION = "duration";
    public static final String KEY_DESTINATION_FILE = "destinationFile";
    public static final String KEY_DESTINATION_COMPRESSED = "destinationCompressed";
    public static final String KEY_START_TIME = "startTime";
    public static final String KEY_MAX_SIZE = "maxSize";
    public static final String KEY_MAX_AGE = "maxAge";
    public static final String KEY_TO_DISK = "toDisk";
    public static final String KEY_DUMP_ON_EXIT = "dumpOnExit";
    private static final String DEFAULT_NAME = "Unnamed Recording";
    private final IMutableConstrainedMap<String> map;

    public RecordingOptionsBuilder(IRecorderConfigurationService service) throws QuantityConversionException {
        this((IMutableConstrainedMap<String>)service.getDefaultRecordingOptions().emptyWithSameConstraints());
    }

    public RecordingOptionsBuilder(IMutableConstrainedMap<String> map) throws QuantityConversionException {
        this.map = map;
        this.name(DEFAULT_NAME);
    }

    public RecordingOptionsBuilder duration(long duration) throws QuantityConversionException {
        return this.duration((IQuantity)UnitLookup.MILLISECOND.quantity(duration));
    }

    public RecordingOptionsBuilder duration(IQuantity duration) throws QuantityConversionException {
        this.map.put((Object)KEY_DURATION, (Object)duration);
        return this;
    }

    public RecordingOptionsBuilder destinationFile(String fileName) throws QuantityConversionException {
        this.map.put((Object)KEY_DESTINATION_FILE, (Object)fileName);
        return this;
    }

    public RecordingOptionsBuilder destinationCompressed(boolean compress) throws QuantityConversionException {
        this.map.put((Object)KEY_DESTINATION_COMPRESSED, (Object)compress);
        return this;
    }

    public RecordingOptionsBuilder startTime(Date startTime) throws QuantityConversionException {
        return this.startTime(UnitLookup.fromDate((Date)startTime));
    }

    public RecordingOptionsBuilder startTime(IQuantity startTime) throws QuantityConversionException {
        this.map.put((Object)KEY_START_TIME, (Object)startTime);
        return this;
    }

    public RecordingOptionsBuilder maxSize(long maxSize) throws QuantityConversionException {
        return this.maxSize((IQuantity)UnitLookup.BYTE.quantity(maxSize));
    }

    public RecordingOptionsBuilder maxSize(IQuantity maxSize) throws QuantityConversionException {
        this.map.put((Object)KEY_MAX_SIZE, (Object)maxSize);
        return this;
    }

    public RecordingOptionsBuilder maxAge(long maxAge) throws QuantityConversionException {
        return this.maxAge((IQuantity)UnitLookup.SECOND.quantity(maxAge));
    }

    public RecordingOptionsBuilder maxAge(IQuantity maxAge) throws QuantityConversionException {
        this.map.put((Object)KEY_MAX_AGE, (Object)maxAge);
        return this;
    }

    public RecordingOptionsBuilder name(String name) throws QuantityConversionException {
        this.map.put((Object)KEY_NAME, (Object)name);
        return this;
    }

    public RecordingOptionsBuilder toDisk(boolean toDisk) throws QuantityConversionException {
        this.map.put((Object)KEY_TO_DISK, (Object)toDisk);
        return this;
    }

    public RecordingOptionsBuilder fromProperties(Properties props) throws QuantityConversionException {
        for (Object element : props.keySet()) {
            String key = (String)element;
            this.addByKey(key, props.getProperty(key));
        }
        return this;
    }

    public RecordingOptionsBuilder addByKey(String key, String property) throws QuantityConversionException {
        this.map.putPersistedString((Object)key, property);
        return this;
    }

    public IConstrainedMap<String> build() throws QuantityConversionException {
        ValidationToolkit.validate(this.map);
        return this.map;
    }
}

