/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.tab;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.console.ui.notification.NotificationPlugin;
import org.openjdk.jmc.console.ui.notification.tab.Messages;
import org.openjdk.jmc.console.ui.notification.tab.RuleGroup;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.triggers.TriggerRule;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationRegistry;
import org.openjdk.jmc.ui.common.util.StatusFactory;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TriggerToolkit {
    private static String PREF_KEY_DEFAULT_TRIGGER_RULES_INITIALIZED = "org.openjdk.jmc.console.ui.notification.table.default.triggers.initialized";
    private static String PREF_KEY_EXPANDED_TRIGGERS = "org.openjdk.jmc.console.ui.notification.table.expanded.rule.groups";
    private static String DUMMY_GROUP_NAME = "Dummy, because IDialogSettings doesn't returns null for an empty array";

    private static boolean hasDefaultTriggersBeenLoaded() {
        return NotificationPlugin.getDefault().getPreferenceStore().getBoolean(PREF_KEY_DEFAULT_TRIGGER_RULES_INITIALIZED);
    }

    private static void setDefaultTriggersLoaded() {
        NotificationPlugin.getDefault().getPreferenceStore().setValue(PREF_KEY_DEFAULT_TRIGGER_RULES_INITIALIZED, true);
    }

    public static NotificationRegistry getDefaultModel() {
        NotificationRegistry notificationRegistry = RJMXPlugin.getDefault().getNotificationRegistry();
        if (!TriggerToolkit.hasDefaultTriggersBeenLoaded()) {
            IStatus status = TriggerToolkit.resetTriggers(notificationRegistry);
            TriggerToolkit.setDefaultTriggersLoaded();
            if (status.getSeverity() != 0) {
                NotificationPlugin.getDefault().getLogger().severe(status.getMessage());
            }
        }
        return notificationRegistry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IStatus resetTriggers(NotificationRegistry model) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                InputStream stream = NotificationPlugin.class.getResourceAsStream("default_rules.xml");
                try {
                    try (BufferedInputStream bis = new BufferedInputStream(stream);){
                        TriggerRule[] rules;
                        Document doc = XmlToolkit.loadDocumentFromStream((InputStream)bis);
                        Collection c = model.getAvailableRules();
                        TriggerRule[] triggerRuleArray = rules = c.toArray(new TriggerRule[c.size()]);
                        int n = rules.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TriggerRule rule = triggerRuleArray[n2];
                            model.removeNotificationRule(rule);
                            ++n2;
                        }
                        Element documentElement = doc.getDocumentElement();
                        ResourceBundle bundle = ResourceBundle.getBundle("org.openjdk.jmc.console.ui.notification.default_rules");
                        TriggerToolkit.translateStringValues(documentElement, bundle, NotificationPlugin.getDefault().getBundle());
                        model.importFromXML(documentElement);
                    }
                    if (stream == null) return StatusFactory.createOk((String)Messages.TriggerToolkit_MESSAGE_DEFAULT_TRIGGERS_LOADED);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return StatusFactory.createOk((String)Messages.TriggerToolkit_MESSAGE_DEFAULT_TRIGGERS_LOADED);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception exc) {
            return StatusFactory.createErr((String)NLS.bind((String)Messages.TriggerToolkit_ERROR_COULD_NOT_READ_DEFAULT_TEMPLATE_FILE, (Object)"default_rules.xml"), (Throwable)exc, (boolean)false);
        }
    }

    private static void translateStringValues(Element e, ResourceBundle bundle, Bundle plugin) {
        String text = XmlToolkit.getStringValue((Element)e);
        if (text != null) {
            XmlToolkit.setStringValue((Element)e, (String)Platform.getResourceString((Bundle)plugin, (String)text, (ResourceBundle)bundle));
        }
        NodeList children = e.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node n = children.item(i);
            if (n instanceof Element) {
                TriggerToolkit.translateStringValues((Element)n, bundle, plugin);
            }
            ++i;
        }
    }

    public static void storeExpansionState(TreeViewer viewer) {
        ArrayList<String> expandThese = new ArrayList<String>();
        expandThese.add(DUMMY_GROUP_NAME);
        Object[] objectArray = viewer.getExpandedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuleGroup group;
            Object element = objectArray[n2];
            if (element instanceof RuleGroup && (group = (RuleGroup)element).getName() != null) {
                expandThese.add(group.getName());
            }
            ++n2;
        }
        NotificationPlugin.getDefault().getDialogSettings().put(PREF_KEY_EXPANDED_TRIGGERS, expandThese.toArray(new String[expandThese.size()]));
    }

    public static void retrieveExpansionState(TreeViewer viewer, NotificationRegistry model) {
        String[] expanded = NotificationPlugin.getDefault().getDialogSettings().getArray(PREF_KEY_EXPANDED_TRIGGERS);
        if (expanded == null) {
            TriggerToolkit.expandRuleGroupWithNames(viewer, TriggerToolkit.getRuleGroupNames(3, model));
        } else {
            TriggerToolkit.expandRuleGroupWithNames(viewer, expanded);
        }
    }

    private static void expandRuleGroupWithNames(TreeViewer viewer, String[] names) {
        ArrayList<RuleGroup> list = new ArrayList<RuleGroup>();
        int n = 0;
        while (n < names.length) {
            if (names[n] != null && !names[n].equals(DUMMY_GROUP_NAME)) {
                list.add(new RuleGroup(names[n]));
            }
            ++n;
        }
        viewer.setExpandedElements(list.toArray());
    }

    private static String[] getRuleGroupNames(int maxCount, NotificationRegistry model) {
        ArrayList<String> list = new ArrayList<String>();
        TriggerRule[] rules = model.getAvailableRules().toArray(new TriggerRule[model.getAvailableRules().size()]);
        int n = 0;
        while (n < rules.length) {
            if (rules[n].getRulePath() != null && !list.contains(rules[n].getRulePath())) {
                list.add(rules[n].getRulePath());
            }
            ++n;
        }
        return list.toArray(new String[list.size()]);
    }
}

