/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.notification.widget;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.openjdk.jmc.console.ui.notification.NotificationPlugin;
import org.openjdk.jmc.console.ui.notification.uicomponents.FieldRenderer;
import org.openjdk.jmc.console.ui.notification.widget.Messages;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.triggers.ITriggerAction;
import org.openjdk.jmc.rjmx.triggers.TriggerRule;
import org.openjdk.jmc.rjmx.triggers.extension.internal.TriggerComponent;
import org.openjdk.jmc.rjmx.triggers.fields.internal.FieldHolder;
import org.openjdk.jmc.rjmx.triggers.internal.INotificationFactory;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationRegistry;
import org.openjdk.jmc.rjmx.triggers.internal.RegistryEntry;
import org.openjdk.jmc.ui.misc.AbstractStructuredContentProvider;
import org.openjdk.jmc.ui.misc.IRefreshable;
import org.openjdk.jmc.ui.uibuilder.IUIBuilder;

public class ActionChooser {
    private static final Logger LOGGER = Logger.getLogger("org.openjdk.jmc.console.ui.notification.widget");
    private final IUIBuilder m_UIbuilder;
    private final boolean m_showDescriptions;
    private final TriggerRule m_notificationRule;
    private final IConnectionHandle m_connectionHandle;
    private final HashMap<String, ITriggerAction> m_actionsCache = new HashMap();
    private TableViewer m_viewer;
    private Table m_table;
    private Composite m_stackContainer;
    private final StackLayout m_stackLayout = new StackLayout();
    private final HashMap<TriggerComponent, Composite> m_mapping = new HashMap();
    private final boolean m_showIcons;
    private final boolean m_vertical;

    public ActionChooser(IUIBuilder builder, TriggerRule notificationRule, IConnectionHandle connectionHandle, NotificationRegistry notificationModel, Composite parent, boolean showDescriptions, boolean showIcons, boolean vertical, ComponentFactory componentFacotry) {
        this.m_UIbuilder = builder;
        this.m_notificationRule = notificationRule;
        this.m_connectionHandle = connectionHandle;
        this.m_showDescriptions = showDescriptions;
        this.m_showIcons = showIcons;
        this.m_vertical = vertical;
        this.buildCache(notificationRule, notificationModel);
        this.create(parent, componentFacotry);
    }

    private void buildCache(TriggerRule notificationRule, NotificationRegistry notificationModel) {
        for (RegistryEntry entry : notificationModel.getAvailableActions()) {
            try {
                INotificationFactory af = notificationModel.getFactory();
                String name = entry.getRegisteredClass().getName();
                ITriggerAction na = af.createAction(name);
                this.m_actionsCache.put(na.getName(), na);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to create trigger action", e);
            }
        }
        if (notificationRule.getAction() != null) {
            this.m_actionsCache.put(notificationRule.getAction().getName(), notificationRule.getAction());
        }
    }

    public IUIBuilder getUIBuilder() {
        return this.m_UIbuilder;
    }

    public List<?> getActivatedConstraints() {
        return this.m_notificationRule.getConstraintHolder().getConstraintList();
    }

    public boolean getHorizontalLayout() {
        return this.m_showDescriptions;
    }

    public Table getTable() {
        return this.m_table;
    }

    private void create(Composite container, ComponentFactory componentFactory) {
        if (this.getUIBuilder() == null || this.m_notificationRule == null) {
            return;
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = this.m_vertical ? 1 : 2;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        container.setLayout((Layout)gridLayout);
        gridLayout.marginTop = 4;
        GridData gd1 = new GridData(4, 4, this.m_vertical, !this.m_vertical);
        gd1.minimumWidth = 0;
        if (!this.m_vertical) {
            gd1.widthHint = 150;
        }
        this.m_table = this.getUIBuilder().createTable(container, false);
        this.m_table.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        if (!this.m_vertical) {
            gd2.widthHint = 500;
        }
        this.m_stackContainer = this.getUIBuilder().createComposite(container);
        this.m_stackContainer.setLayoutData((Object)gd2);
        this.createStacks(componentFactory);
        this.createViewer(this.m_table);
    }

    private void createStacks(ComponentFactory componentFactory) {
        this.m_stackContainer.setLayout((Layout)this.m_stackLayout);
        for (ITriggerAction action : this.m_actionsCache.values()) {
            Composite customComponent;
            if (!(action instanceof TriggerComponent)) continue;
            TriggerComponent component = (TriggerComponent)action;
            FieldHolder holder = component.getFieldHolder();
            Composite stackContainer = this.getUIBuilder().createComposite(this.m_stackContainer);
            this.getUIBuilder().setContainer(stackContainer);
            if (this.m_showDescriptions) {
                this.getUIBuilder().createCaption(component.getName());
                this.getUIBuilder().layout();
                this.getUIBuilder().createSeparator();
                this.getUIBuilder().layout();
                this.getUIBuilder().layout();
                this.getUIBuilder().createFormText(component.getDescription(), null);
                this.getUIBuilder().layout();
            }
            if (holder.getFields().length == 0) {
                this.getUIBuilder().createFormText(Messages.ActionChooser_LABEL_NO_SETTINGS_AVAILABLE, null);
                this.getUIBuilder().layout();
            }
            FieldRenderer tcr = new FieldRenderer(holder, this.getUIBuilder());
            tcr.render();
            if (componentFactory != null && (customComponent = componentFactory.createComponent(stackContainer, action)) != null) {
                this.getUIBuilder().setCompositeLayout(customComponent);
                this.getUIBuilder().layout();
            }
            this.m_mapping.put(component, stackContainer);
        }
    }

    public TableViewer getViewer() {
        return this.m_viewer;
    }

    private void createViewer(Table table) {
        this.m_viewer = new TableViewer(table);
        this.m_viewer.setContentProvider((IContentProvider)new TriggerContentProvider());
        this.m_viewer.setLabelProvider((IBaseLabelProvider)new ActionLabelProvider(this.m_connectionHandle));
        this.m_viewer.setInput(this.m_actionsCache);
        this.m_viewer.setComparator(new ViewerComparator());
        this.m_viewer.refresh();
        ITriggerAction action = this.m_notificationRule.getAction();
        if (action != null) {
            this.m_viewer.setSelection((ISelection)new StructuredSelection((Object)action));
            this.select(action);
        }
    }

    public void createAndAddActionSelectionChangedListener(final IRefreshable postSelection) {
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection s = (IStructuredSelection)event.getSelection();
                Object obj = s.getFirstElement();
                if (obj instanceof ITriggerAction) {
                    ActionChooser.this.m_notificationRule.setAction((ITriggerAction)obj);
                    ActionChooser.this.select(obj);
                    if (postSelection != null) {
                        postSelection.refresh();
                    }
                }
            }
        };
        this.m_viewer.addSelectionChangedListener(listener);
    }

    public StackLayout getStackLayout() {
        return this.m_stackLayout;
    }

    public void select(Object object) {
        Control c = (Control)this.m_mapping.get(object);
        if (c != null) {
            this.getStackLayout().topControl = c;
            if (!this.m_stackContainer.isDisposed()) {
                this.m_stackContainer.layout();
            }
        }
        if (!this.m_viewer.getControl().isDisposed()) {
            this.m_viewer.refresh();
        }
    }

    public class ActionLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private final IConnectionHandle m_connectionHandle;

        public ActionLabelProvider(IConnectionHandle connectionHandle) {
            this.m_connectionHandle = connectionHandle;
        }

        public Image getImage(Object element) {
            return ActionChooser.this.m_showIcons ? NotificationPlugin.getDefault().getImage(element, this.isSupportedByConnection(element)) : null;
        }

        public String getText(Object element) {
            if (element instanceof ITriggerAction) {
                return ((ITriggerAction)element).getName();
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (this.isSupportedByConnection(element)) {
                return null;
            }
            return JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
        }

        private boolean isSupportedByConnection(Object action) {
            return action instanceof ITriggerAction && ((ITriggerAction)action).supportsAction(this.m_connectionHandle);
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    public static interface ComponentFactory {
        public Composite createComponent(Composite var1, ITriggerAction var2);
    }

    public class TriggerContentProvider
    extends AbstractStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return ActionChooser.this.m_actionsCache.values().toArray();
        }
    }
}

