/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx;

import org.openjdk.jmc.common.jvm.JVMDescriptor;
import org.openjdk.jmc.common.jvm.JVMType;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.common.version.JavaVersionSupport;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.common.ConnectionToolkit;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.internal.ServerToolkit;
import org.openjdk.jmc.rjmx.messages.internal.Messages;

public final class JVMSupportToolkit {
    private JVMSupportToolkit() {
        throw new IllegalArgumentException("Don't instantiate this toolkit");
    }

    public static String[] checkConsoleSupport(IConnectionHandle connection) {
        String title = null;
        String message = null;
        if (ConnectionToolkit.isJRockit((IConnectionHandle)connection)) {
            title = Messages.JVMSupport_TITLE_JROCKIT_NOT_SUPPORTED;
            message = Messages.JVMSupport_MESSAGE_JROCKIT_NOT_SUPPORTED;
        } else if (!ConnectionToolkit.isHotSpot((IConnectionHandle)connection) && !ConnectionToolkit.isSubstrateVM((IConnectionHandle)connection)) {
            title = Messages.JVMSupport_TITLE_UNKNOWN_JVM;
            message = Messages.JVMSupport_MESSAGE_UNKNOWN_JVM;
        } else if (!ConnectionToolkit.isJavaVersionAboveOrEqual((IConnectionHandle)connection, (JavaVersion)JavaVersionSupport.DIAGNOSTIC_COMMANDS_SUPPORTED)) {
            title = Messages.JVMSupport_TITLE_LEGACY_JVM_CONSOLE;
            message = Messages.JVMSupport_MESSAGE_LEGACY_JVM_CONSOLE;
        }
        if (title != null) {
            String[] returnInfo = new String[]{title, message};
            return returnInfo;
        }
        return new String[0];
    }

    public static String getNoFlightRecorderErrorMessage(IConnectionHandle handle, boolean shortMessage) {
        if (ConnectionToolkit.isJRockit((IConnectionHandle)handle)) {
            return JVMSupportToolkit.getJfrJRockitNotSupported(shortMessage);
        }
        if (!ConnectionToolkit.isHotSpot((IConnectionHandle)handle)) {
            return JVMSupportToolkit.getJfrNonHotSpotNotSupported(shortMessage);
        }
        if (!ConnectionToolkit.isJavaVersionAboveOrEqual((IConnectionHandle)handle, (JavaVersion)JavaVersionSupport.JFR_ENGINE_SUPPORTED)) {
            return JVMSupportToolkit.getJfrOldHotSpotNotSupported(shortMessage);
        }
        if (ConnectionToolkit.isFlightRecorderDisabled((IConnectionHandle)handle, (boolean)true)) {
            return JVMSupportToolkit.getJfrDisabled(shortMessage);
        }
        return JVMSupportToolkit.getJfrNotEnabled(shortMessage);
    }

    public static String checkFlightRecorderSupport(IServerHandle handle, boolean shortMessage) {
        if (ServerToolkit.getJvmInfo(handle) != null) {
            JVMDescriptor jvmInfo = ServerToolkit.getJvmInfo(handle);
            if (jvmInfo.getJvmType() == null) {
                return null;
            }
            if (jvmInfo.getJvmType() == JVMType.JROCKIT) {
                return JVMSupportToolkit.getJfrJRockitNotSupported(shortMessage);
            }
            if (jvmInfo.getJvmType() == JVMType.UNKNOWN) {
                return null;
            }
            if (jvmInfo.getJvmType() == JVMType.SUBSTRATE) {
                return null;
            }
            if (jvmInfo.getJvmType() != JVMType.HOTSPOT) {
                return JVMSupportToolkit.getJfrNonHotSpotNotSupported(shortMessage);
            }
            if (jvmInfo.getJavaVersion() == null) {
                return null;
            }
            if (!new JavaVersion(jvmInfo.getJavaVersion()).isGreaterOrEqualThan(JavaVersionSupport.JFR_ENGINE_SUPPORTED)) {
                return JVMSupportToolkit.getJfrOldHotSpotNotSupported(shortMessage);
            }
            if (!new JavaVersion(jvmInfo.getJavaVersion()).isGreaterOrEqualThan(JavaVersionSupport.JFR_FULLY_SUPPORTED)) {
                return JVMSupportToolkit.getJfrOldHotSpotNotFullySupported(shortMessage);
            }
        }
        return null;
    }

    private static String getJfrNotEnabled(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_ENABLED_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_ENABLED;
    }

    private static String getJfrDisabled(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_DISABLED_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_DISABLED;
    }

    private static String getJfrOldHotSpotNotSupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_OLD_HOTSPOT_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_OLD_HOTSPOT;
    }

    private static String getJfrOldHotSpotNotFullySupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_FULLY_SUPPORTED_OLD_HOTSPOT_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_FULLY_SUPPORTED_OLD_HOTSPOT;
    }

    private static String getJfrNonHotSpotNotSupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_NOT_HOTSPOT_SHORT : Messages.JVMSupport_FLIGHT_RECORDER_NOT_SUPPORTED_NOT_HOTSPOT;
    }

    private static String getJfrJRockitNotSupported(boolean shortMessage) {
        return shortMessage ? Messages.JVMSupport_JROCKIT_NO_LONGER_SUPPORTED_SHORT : Messages.JVMSupport_JROCKIT_NO_LONGER_SUPPORTED;
    }
}

