/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.actions.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.services.IDiagnosticCommandService;
import org.openjdk.jmc.rjmx.triggers.TriggerAction;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;
import org.openjdk.jmc.rjmx.triggers.actions.internal.Messages;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationToolkit;
import org.openjdk.jmc.ui.common.idesupport.IDESupportToolkit;
import org.openjdk.jmc.ui.common.resource.MCFile;

public class TriggerActionDiagnosticCommand
extends TriggerAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotificationEvent(TriggerEvent e) throws IllegalArgumentException, Exception {
        String command = this.getSetting("command").getString();
        Boolean append = this.getSetting("append").getBoolean();
        String result = ((IDiagnosticCommandService)e.getSource().getServiceOrThrow(IDiagnosticCommandService.class)).runCtrlBreakHandlerWithResult(command);
        ByteArrayInputStream stream = new ByteArrayInputStream(result.getBytes(StandardCharsets.UTF_8));
        String triggerMessage = NotificationToolkit.prettyPrint(e);
        TriggerActionDiagnosticCommand triggerActionDiagnosticCommand = this;
        synchronized (triggerActionDiagnosticCommand) {
            MCFile file = IDESupportToolkit.createFileResource((String)this.getLogFileName());
            String jobName = append != false ? Messages.TriggerActionDiagnosticCommand_APPEND_ACTION_TEXT : Messages.TriggerActionDiagnosticCommand_WRITE_ACTION_TEXT;
            IDESupportToolkit.writeAsJob((String)jobName, (MCFile)file, (InputStream)stream, (boolean)append, (String)triggerMessage);
        }
    }

    private String getLogFileName() {
        return this.getSetting("log_file").getFileName();
    }

    @Override
    public boolean supportsAction(IConnectionHandle handle) {
        return handle.getServiceOrNull(IDiagnosticCommandService.class) != null;
    }
}

