/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.actions.internal;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.openjdk.jmc.rjmx.triggers.actions.internal.Messages;
import org.openjdk.jmc.rjmx.triggers.fields.internal.Field;

public class TriggerActionValidator
extends Job {
    private final String name;
    private final Field field;

    public TriggerActionValidator(String name, Field field) {
        super(name);
        this.name = name;
        this.field = field;
    }

    protected IStatus run(IProgressMonitor monitor) {
        String value;
        if (this.name.equals("PathValidation")) {
            File driveFile;
            Path filePath = Paths.get(this.field.getValue(), new String[0]);
            Path root = filePath.getRoot();
            if (root != null && !(driveFile = new File(root.toString())).exists()) {
                this.setDefaultValue();
                return new Status(4, "org.openjdk.jmc.ui.common", NLS.bind((String)Messages.TriggerActionValidator_INVALID_PATH, (Object)this.field.getValue()), (Throwable)new Exception(NLS.bind((String)Messages.TriggerActionValidator_INVALID_PATH, (Object)this.field.getValue())));
            }
        } else if (this.name.equals("EmailValidation") && !(value = this.field.getValue()).isEmpty()) {
            String[] split;
            String[] stringArray = split = value.split(",|;|\\s");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String sp = stringArray[n2];
                String REGEX = "^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$";
                boolean matches = sp.trim().matches(REGEX);
                if (!matches) {
                    this.setDefaultValue();
                    return new Status(4, "org.openjdk.jmc.ui.common", NLS.bind((String)Messages.TriggerActionValidator_INVALID_EMAIL, (Object)this.field.getValue()), (Throwable)new Exception(NLS.bind((String)Messages.TriggerActionValidator_INVALID_EMAIL, (Object)this.field.getValue())));
                }
                ++n2;
            }
        }
        return new Status(0, "org.openjdk.jmc.ui.common", "");
    }

    private void setDefaultValue() {
        switch (this.field.getId()) {
            case "dumpfilename": {
                this.setDefaultValue("automaticallyTriggeredRecording.jfr");
                break;
            }
            case "recordingfilename": {
                this.setDefaultValue("automaticallyTriggeredRecording.jfr");
                break;
            }
            case "filename": {
                this.setDefaultValue("default.hprof");
                break;
            }
            case "log_file": {
                this.setDefaultValue("command.log");
                break;
            }
            case "logfilename": {
                this.setDefaultValue("log.txt");
                break;
            }
            default: {
                this.setDefaultValue("");
            }
        }
    }

    private void setDefaultValue(final String value) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TriggerActionValidator.this.field.setValue(value);
            }
        });
    }
}

