/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.triggers.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.util.XmlToolkit;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.subscription.MRI;
import org.openjdk.jmc.rjmx.common.subscription.MRIValueEvent;
import org.openjdk.jmc.rjmx.subscription.internal.ExtendedMRIMetadataToolkit;
import org.openjdk.jmc.rjmx.triggers.IExceptionHandler;
import org.openjdk.jmc.rjmx.triggers.ITrigger;
import org.openjdk.jmc.rjmx.triggers.IValueEvaluator;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;
import org.openjdk.jmc.rjmx.triggers.TriggerRule;
import org.openjdk.jmc.rjmx.triggers.extension.internal.ExtensionLoader;
import org.openjdk.jmc.rjmx.triggers.internal.INotificationFactory;
import org.openjdk.jmc.rjmx.triggers.internal.NotificationToolkit;
import org.w3c.dom.Element;

public class NotificationTrigger
implements ITrigger {
    public static final int TRIGGER_ON_RULE_TRIGGERED = 1;
    public static final int TRIGGER_ON_RULE_RECOVERED = 2;
    public static final int TRIGGER_ON_RULE_TRIGGERED_AND_RECOVERED = 3;
    private static final int STATE_START = 0;
    private static final int STATE_TRIGGER_HIGH = 1;
    private static final int STATE_TRIGGER_LOW = 2;
    private static final int STATE_WAITING_SUSTAIN_HIGH = 3;
    private static final int STATE_WAITING_SUSTAIN_LOW = 4;
    private static final int TRIGGER_ERROR_HANDLING_LIMIT_TIME_MS = 60000;
    private static final String XML_ELEMENT_LIMIT_PERIOD = "trigger_limit_period";
    private static final String XML_ELEMENT_SUSTAIN_TIME = "trigger_sustain_time";
    private static final String XML_ELEMENT_ON_WHAT = "trigger_on_what";
    private static final String XML_VALUE_EVALUATOR_COMPONENT_TAG = "value_evaluator";
    private static final String XML_VALUE_EVALUATOR_TYPE_ATTRIBUTE_NAME = "type";
    public static final String XML_ELEMENT_ATTRIBUTE_NAME = "notification_attribute_name";
    private volatile MRI m_notificationAttributeDescriptor;
    private volatile IValueEvaluator m_valueEvaluator;
    private volatile int m_limitTime;
    private volatile int m_sustainTime;
    private volatile int m_triggerOn = 3;
    private final HashMap<String, StateStore> uidToStateStoreMap = new HashMap();
    private static final List<IExceptionHandler> EXCEPTION_HANDLERS = new LinkedList<IExceptionHandler>();

    public NotificationTrigger() {
    }

    public NotificationTrigger(MRI descriptor, IValueEvaluator evaluator) {
        this.setAttributeDescriptor(descriptor);
        this.setValueEvaluator(evaluator);
    }

    @Override
    public MRI getAttributeDescriptor() {
        return this.m_notificationAttributeDescriptor;
    }

    public void setAttributeDescriptor(MRI notificationAttributeDescriptor) {
        this.m_notificationAttributeDescriptor = notificationAttributeDescriptor;
    }

    @Override
    public IValueEvaluator getValueEvaluator() {
        return this.m_valueEvaluator;
    }

    public void setValueEvaluator(IValueEvaluator valueEvaluator) {
        this.m_valueEvaluator = valueEvaluator;
    }

    private StateStore getStateStoreForUID(String uid) {
        StateStore store = this.uidToStateStoreMap.get(uid);
        if (store == null) {
            store = new StateStore();
            this.uidToStateStoreMap.put(uid, store);
        }
        return store;
    }

    @Override
    public void triggerOn(IConnectionHandle connectionHandle, TriggerRule rule, MRIValueEvent aspectEvent) {
        boolean triggered;
        MRI mri;
        IUnit unit;
        if (aspectEvent.getValue() == null) {
            return;
        }
        Object eventValue = aspectEvent.getValue();
        StateStore stateStore = this.getStateStoreForUID(connectionHandle.getServerDescriptor().getGUID());
        if (eventValue instanceof Number && (unit = ExtendedMRIMetadataToolkit.getUnit(connectionHandle, mri = aspectEvent.getMRI())) != null) {
            eventValue = unit.quantity((Number)eventValue);
        }
        try {
            triggered = this.getValueEvaluator().triggerOn(eventValue);
        }
        catch (Exception e) {
            if (stateStore.m_lastTriggerErrorTimestamp == null || aspectEvent.getTimestamp() - stateStore.m_lastTriggerErrorTimestamp >= 60000L) {
                stateStore.m_lastTriggerErrorTimestamp = aspectEvent.getTimestamp();
                this.handleException(connectionHandle, rule, e, null);
            }
            return;
        }
        if (stateStore.m_triggerState == 0 || this.getSustainTimeMillis() == 0) {
            stateStore.m_triggerState = triggered ? 3 : 4;
            stateStore.m_lastSwitchEventTimestamp = aspectEvent.getTimestamp();
        }
        switch (stateStore.m_triggerState) {
            case 3: {
                if (triggered) {
                    if (stateStore.m_lastTriggeredState != 2 && stateStore.m_lastTriggeredState != 0 || aspectEvent.getTimestamp() - stateStore.m_lastSwitchEventTimestamp < (long)this.getSustainTimeMillis() || stateStore.m_lastTriggerEventTimestamp != null && aspectEvent.getTimestamp() - stateStore.m_lastTriggerEventTimestamp < (long)this.getLimitTimeMillis()) break;
                    this.doTrigger(1, connectionHandle, rule, aspectEvent, (this.getTriggerOn() & 1) > 0);
                    break;
                }
                stateStore.m_lastSwitchEventTimestamp = aspectEvent.getTimestamp();
                stateStore.m_triggerState = 4;
                break;
            }
            case 1: {
                if (triggered) break;
                stateStore.m_lastSwitchEventTimestamp = aspectEvent.getTimestamp();
                stateStore.m_triggerState = 4;
                break;
            }
            case 2: {
                if (!triggered) break;
                stateStore.m_lastSwitchEventTimestamp = aspectEvent.getTimestamp();
                stateStore.m_triggerState = 3;
                break;
            }
            case 4: {
                if (!triggered) {
                    if (stateStore.m_lastTriggeredState != 1 || aspectEvent.getTimestamp() - stateStore.m_lastSwitchEventTimestamp < (long)this.getSustainTimeMillis() || stateStore.m_lastTriggerEventTimestamp != null && aspectEvent.getTimestamp() - stateStore.m_lastTriggerEventTimestamp < (long)this.getLimitTimeMillis()) break;
                    this.doTrigger(2, connectionHandle, rule, aspectEvent, (this.getTriggerOn() & 2) > 0);
                    break;
                }
                stateStore.m_lastSwitchEventTimestamp = aspectEvent.getTimestamp();
                stateStore.m_triggerState = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Trigger entered illegal state!");
            }
        }
    }

    private void doTrigger(int triggState, IConnectionHandle connectionHandle, TriggerRule rule, MRIValueEvent aspectEvent, boolean notificationEnabled) {
        StateStore stateStore = this.getStateStoreForUID(connectionHandle.getServerDescriptor().getGUID());
        TriggerEvent event = new TriggerEvent(connectionHandle, rule, aspectEvent.getValue(), triggState == 1, (int)(aspectEvent.getTimestamp() - stateStore.m_lastSwitchEventTimestamp));
        if (!NotificationTrigger.checkConstraints(rule, event)) {
            return;
        }
        stateStore.m_lastTriggeredState = triggState;
        stateStore.m_triggerState = triggState;
        if (notificationEnabled) {
            stateStore.m_lastTriggerEventTimestamp = aspectEvent.getTimestamp();
            String triggerMessage = NotificationToolkit.prettyPrint(event);
            try {
                rule.getAction().handleNotificationEvent(event);
            }
            catch (Throwable e) {
                this.handleException(connectionHandle, rule, e, triggerMessage);
            }
        }
    }

    private void handleException(IConnectionHandle connectionHandle, TriggerRule rule, Throwable e, String triggerMessage) {
        IExceptionHandler[] handlers;
        IExceptionHandler[] iExceptionHandlerArray = handlers = this.getExceptionHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IExceptionHandler handler = iExceptionHandlerArray[n2];
            handler.handleException(connectionHandle, rule, e, triggerMessage);
            ++n2;
        }
    }

    private synchronized IExceptionHandler[] getExceptionHandlers() {
        if (EXCEPTION_HANDLERS.size() == 0) {
            this.initializeExceptionHandlers();
        }
        return EXCEPTION_HANDLERS.toArray(new IExceptionHandler[EXCEPTION_HANDLERS.size()]);
    }

    private void initializeExceptionHandlers() {
        ExtensionLoader loader = new ExtensionLoader("org.openjdk.jmc.rjmx.triggerActionExceptionHandlers", "exceptionHandler");
        EXCEPTION_HANDLERS.addAll(loader.getPrototypes());
    }

    private static boolean checkConstraints(TriggerRule rule, TriggerEvent e) {
        if (!rule.hasConstraints()) {
            return true;
        }
        return rule.getConstraintHolder().isValid(e);
    }

    public int getLimitTime() {
        return this.m_limitTime;
    }

    public int getLimitTimeMillis() {
        return this.m_limitTime * 1000;
    }

    public void setLimitTime(int waitTime) {
        this.m_limitTime = waitTime;
    }

    public String toString() {
        return "NotificationTrigger type = " + this.getAttributeDescriptor().toString() + "  eval = " + this.getValueEvaluator().toString();
    }

    public int getTriggerOn() {
        return this.m_triggerOn;
    }

    public void setTriggerOn(int triggerOn) {
        if (triggerOn < 0 || triggerOn > 3) {
            throw new IllegalArgumentException(triggerOn + " is not a valid trigger flank!");
        }
        this.m_triggerOn = triggerOn;
    }

    public void initializeFromXml(Element node, INotificationFactory factory) {
        IValueEvaluator evaluator = null;
        int triggerOn = Integer.parseInt(XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_ON_WHAT, (String)String.valueOf(3)));
        int waitTime = Integer.parseInt(XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_LIMIT_PERIOD, (String)"0"));
        int sustainTime = Integer.parseInt(XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_SUSTAIN_TIME, (String)"0"));
        String typeName = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_ATTRIBUTE_NAME, null);
        assert (typeName != null);
        MRI descriptor = MRI.createFromQualifiedName((String)typeName);
        Element evalNode = XmlToolkit.getOrCreateElement((Element)node, (String)XML_VALUE_EVALUATOR_COMPONENT_TAG);
        String evaluatorClass = evalNode.getAttribute(XML_VALUE_EVALUATOR_TYPE_ATTRIBUTE_NAME);
        if ("".equals(evaluatorClass) && (evaluatorClass = XmlToolkit.getSetting((Element)node, (String)"value_evaluator_class", null)) == null) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "No element specifying the value evaluator class!");
            return;
        }
        assert (evaluatorClass != null);
        try {
            evaluator = factory.createEvaluator(evaluatorClass);
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Error instantiating value evaluator", e);
            return;
        }
        evaluator.initializeEvaluatorFromXml(evalNode);
        this.setAttributeDescriptor(descriptor);
        this.setTriggerOn(triggerOn);
        this.setValueEvaluator(evaluator);
        this.setSustainTime(sustainTime);
        this.setLimitTime(waitTime);
    }

    public void exportToXml(Element triggerNode) {
        XmlToolkit.setSetting((Element)triggerNode, (String)XML_ELEMENT_LIMIT_PERIOD, (String)Integer.toString(this.getLimitTime()));
        XmlToolkit.setSetting((Element)triggerNode, (String)XML_ELEMENT_SUSTAIN_TIME, (String)Integer.toString(this.getSustainTime()));
        XmlToolkit.setSetting((Element)triggerNode, (String)XML_ELEMENT_ON_WHAT, (String)Integer.toString(this.getTriggerOn()));
        XmlToolkit.setSetting((Element)triggerNode, (String)XML_ELEMENT_ATTRIBUTE_NAME, (String)this.getAttributeDescriptor().getQualifiedName());
        Element evalNode = XmlToolkit.createElement((Element)triggerNode, (String)XML_VALUE_EVALUATOR_COMPONENT_TAG);
        evalNode.setAttribute(XML_VALUE_EVALUATOR_TYPE_ATTRIBUTE_NAME, this.getValueEvaluator().getClass().getName());
        this.getValueEvaluator().exportEvaluatorToXml(evalNode);
    }

    @Override
    public int getSustainTime() {
        return this.m_sustainTime;
    }

    public int getSustainTimeMillis() {
        return this.m_sustainTime * 1000;
    }

    public void setSustainTime(int sustainTime) {
        this.m_sustainTime = sustainTime;
    }

    public void clearState(String uid) {
        this.uidToStateStoreMap.remove(uid);
    }

    static class StateStore {
        int m_lastTriggeredState = 0;
        int m_triggerState = 0;
        Long m_lastSwitchEventTimestamp;
        Long m_lastTriggerEventTimestamp;
        Long m_lastTriggerErrorTimestamp;

        StateStore() {
        }
    }
}

