/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.openjdk.jmc.common.util.ExceptionToolkit;

public class StatusFactory {
    public static IStatus createErr(String message, Throwable cause, boolean showStackTrace) {
        String subMsg;
        if (cause == null) {
            return StatusFactory.createErr(message);
        }
        Object status = showStackTrace ? StatusFactory.expandStackTrace(cause) : new Status(4, "org.openjdk.jmc.ui.common", 0, (subMsg = cause.getLocalizedMessage()) != null ? subMsg : cause.getClass().getName(), null);
        return new MultiStatus("org.openjdk.jmc.ui.common", 0, new IStatus[]{status}, message, null);
    }

    public static IStatus createErr(String message) {
        return new Status(4, "org.openjdk.jmc.ui.common", 0, message, null);
    }

    public static IStatus createOk(String message) {
        return new Status(0, "org.openjdk.jmc.ui.common", 0, message, null);
    }

    private static IStatus expandStackTrace(Throwable e) {
        String[] lines = ExceptionToolkit.toString((Throwable)e).split("[\r\n]+");
        IStatus[] statuses = new IStatus[lines.length];
        int i = 0;
        while (i < statuses.length) {
            statuses[i] = new Status(4, "org.openjdk.jmc.ui.common", 0, lines[i], null);
            ++i;
        }
        return new MultiStatus("org.openjdk.jmc.ui.common", 0, statuses, e.getClass().getName() + ": " + e.getLocalizedMessage(), null);
    }
}

