/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.common;

import java.awt.Graphics2D;
import java.awt.Point;
import java.util.stream.Stream;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemCollectionToolkit;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.item.RangeMatchPolicy;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.ui.charts.IChartInfoVisitor;
import org.openjdk.jmc.ui.charts.IRenderedRow;
import org.openjdk.jmc.ui.charts.IXDataRenderer;
import org.openjdk.jmc.ui.charts.RenderedRowBase;
import org.openjdk.jmc.ui.charts.SubdividedQuantityRange;
import org.openjdk.jmc.ui.charts.XYChart;

public class ItemRow
implements IXDataRenderer {
    private final IItemCollection items;
    private final IXDataRenderer renderer;
    private final String name;
    private final String description;

    public ItemRow(IXDataRenderer renderer, IItemCollection items) {
        this(null, null, renderer, items);
    }

    public ItemRow(String name, String description, IXDataRenderer renderer, IItemCollection items) {
        this.name = name;
        this.description = description;
        this.items = items;
        this.renderer = renderer;
    }

    public static IItemCollection getSelection(XYChart chart) {
        Object[] selectedRows = chart.getSelectedRows();
        if (selectedRows.length == 0) {
            return ItemCollectionToolkit.EMPTY;
        }
        return ItemCollectionToolkit.merge(() -> Stream.of(selectedRows).filter(row -> row instanceof ItemRow).map(row -> ((ItemRow)row).items));
    }

    public static IItemCollection getSelection(XYChart chart, ICanonicalAccessorFactory<IQuantity> attribute) {
        IQuantity start = chart.getSelectionStart();
        IQuantity end = chart.getSelectionEnd();
        if (start != null && end != null) {
            IItemFilter rangeFilter = ItemFilters.interval(attribute, (Comparable)start, (boolean)true, (Comparable)end, (boolean)true);
            return ItemRow.getSelection(chart).apply(rangeFilter);
        }
        return ItemRow.getSelection(chart);
    }

    public static IItemCollection getRangeSelection(XYChart chart, ICanonicalAccessorFactory<IRange<IQuantity>> attribute) {
        IRange range = chart.getSelectionRange();
        if (range != null) {
            IItemFilter rangeFilter = ItemFilters.matchRange((RangeMatchPolicy)RangeMatchPolicy.CONTAINED_IN_CLOSED, attribute, (IRange)range);
            return ItemRow.getSelection(chart).apply(rangeFilter);
        }
        return ItemRow.getSelection(chart);
    }

    public IRenderedRow render(Graphics2D context, SubdividedQuantityRange xRange, int height) {
        final IRenderedRow render = this.renderer.render(context, xRange, height);
        return new RenderedRowBase(render.getNestedRows(), height, this.name == null ? render.getName() : this.name, this.description == null ? render.getDescription() : this.description, this){

            public void infoAt(IChartInfoVisitor visitor, int x, int y, Point offset) {
                render.infoAt(visitor, x, y, offset);
            }
        };
    }
}

