/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.openjdk.jmc.common.IState;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.ui.FlightRecorderUI;
import org.openjdk.jmc.flightrecorder.ui.IDataPageFactory;
import org.openjdk.jmc.flightrecorder.ui.IDisplayablePage;
import org.openjdk.jmc.flightrecorder.ui.IPageContainer;
import org.openjdk.jmc.flightrecorder.ui.IPageDefinition;
import org.openjdk.jmc.flightrecorder.ui.IPageUI;
import org.openjdk.jmc.flightrecorder.ui.StreamModel;
import org.openjdk.jmc.flightrecorder.ui.common.AbstractDataPage;
import org.openjdk.jmc.flightrecorder.ui.common.DataPageToolkit;
import org.openjdk.jmc.flightrecorder.ui.common.ItemAggregateViewer;
import org.openjdk.jmc.flightrecorder.ui.messages.internal.Messages;
import org.openjdk.jmc.ui.accessibility.SimpleTraverseListener;
import org.openjdk.jmc.ui.misc.CompositeToolkit;

public class GCSummaryPage
extends AbstractDataPage {
    @Override
    public IPageUI display(Composite parent, FormToolkit toolkit, IPageContainer pageContainer, IState state) {
        Form form = DataPageToolkit.createForm(parent, toolkit, this.getName(), this.getIcon());
        SashForm mainContainer = new SashForm(form.getBody(), 512);
        mainContainer.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        SashForm firstContainer = new SashForm((Composite)mainContainer, 256);
        firstContainer.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        Section youngCollectionSection = CompositeToolkit.createSection((Composite)firstContainer, (FormToolkit)toolkit, (String)Messages.GCSummaryPage_SECTION_YOUNG_COLLECTION);
        ItemAggregateViewer ycConfig = new ItemAggregateViewer((Composite)youngCollectionSection, toolkit);
        ycConfig.addAggregate(JdkAggregators.YOUNG_COLLECTION_GC_COUNT);
        ycConfig.addAggregate(JdkAggregators.YOUNG_COLLECTION_AVG_GC_TIME);
        ycConfig.addAggregate(JdkAggregators.YOUNG_COLLECTION_MAX_GC_TIME);
        ycConfig.addAggregate(JdkAggregators.YOUNG_COLLECTION_TOTAL_GC_TIME);
        youngCollectionSection.setClient(ycConfig.getControl());
        Section oldCollectionSection = CompositeToolkit.createSection((Composite)firstContainer, (FormToolkit)toolkit, (String)Messages.GCSummaryPage_SECTION_OLD_COLLECTION);
        ItemAggregateViewer ocConfig = new ItemAggregateViewer((Composite)oldCollectionSection, toolkit);
        ocConfig.addAggregate(JdkAggregators.OLD_COLLECTION_GC_COUNT);
        ocConfig.addAggregate(JdkAggregators.OLD_COLLECTION_AVG_GC_TIME);
        ocConfig.addAggregate(JdkAggregators.OLD_COLLECTION_MAX_GC_TIME);
        ocConfig.addAggregate(JdkAggregators.OLD_COLLECTION_TOTAL_GC_TIME);
        oldCollectionSection.setClient(ocConfig.getControl());
        SashForm secondContainer = new SashForm((Composite)mainContainer, 256);
        secondContainer.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        Section allCollectionSection = CompositeToolkit.createSection((Composite)secondContainer, (FormToolkit)toolkit, (String)Messages.GCSummaryPage_SECTION_ALL_COLLECTION);
        ItemAggregateViewer acConfig = new ItemAggregateViewer((Composite)allCollectionSection, toolkit);
        acConfig.addAggregate(JdkAggregators.ALL_COLLECTION_GC_COUNT);
        acConfig.addAggregate(JdkAggregators.ALL_COLLECTION_AVG_GC_TIME);
        acConfig.addAggregate(JdkAggregators.ALL_COLLECTION_MAX_GC_TIME);
        acConfig.addAggregate(JdkAggregators.ALL_COLLECTION_TOTAL_GC_TIME);
        allCollectionSection.setClient(acConfig.getControl());
        Section allCollectionPauseSection = CompositeToolkit.createSection((Composite)secondContainer, (FormToolkit)toolkit, (String)Messages.GCSummaryPage_SECTION_ALL_COLLECTION_PAUSE);
        ItemAggregateViewer acpConfig = new ItemAggregateViewer((Composite)allCollectionPauseSection, toolkit);
        acpConfig.addAggregate(JdkAggregators.AVERAGE_GC_PAUSE);
        acpConfig.addAggregate(JdkAggregators.LONGEST_GC_PAUSE);
        acpConfig.addAggregate(JdkAggregators.TOTAL_GC_PAUSE);
        allCollectionPauseSection.setClient(acpConfig.getControl());
        ycConfig.setValues(this.getDataSource().getItems());
        ocConfig.setValues(this.getDataSource().getItems());
        acConfig.setValues(this.getDataSource().getItems());
        acpConfig.setValues(this.getDataSource().getItems());
        this.addResultActions(form);
        return null;
    }

    public GCSummaryPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
        super(dpd, items, editor);
    }

    @Override
    public IItemFilter getDefaultSelectionFilter() {
        return JdkFilters.GC_CONFIG;
    }

    public static class GCSummaryPageFactory
    implements IDataPageFactory {
        @Override
        public String getName(IState state) {
            return Messages.GCSummaryPage_PAGE_NAME;
        }

        @Override
        public ImageDescriptor getImageDescriptor(IState state) {
            return FlightRecorderUI.getDefault().getMCImageDescriptor("pages/gc.png");
        }

        @Override
        public String[] getTopics(IState state) {
            return new String[]{"gc_summary"};
        }

        @Override
        public IDisplayablePage createPage(IPageDefinition dpd, StreamModel items, IPageContainer editor) {
            return new GCSummaryPage(dpd, items, editor);
        }
    }
}

