/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.JvmInternalsDataProvider;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class DuplicateFlagsRule
implements IRule {
    private static final String RESULT_ID = "DuplicateFlags";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = new HashMap<String, RulesToolkit.EventAvailability>();
    private static final ContentType<DuplicateFlags> DUPLICATE_FLAGS = UnitLookup.createSyntheticContentType((String)"duplicateFlags");
    public static final TypedCollectionResult<DuplicateFlags> DUPLICATED_FLAGS = new TypedCollectionResult("duplicateFlags", Messages.getString("DuplicateFlagsRule_RESULT_DUPLICATED_FLAGS_NAME"), Messages.getString("DuplicateFlagsRule_RESULT_DUPLICATED_FLAGS_DESCRIPTION"), DUPLICATE_FLAGS, DuplicateFlags.class);
    public static final TypedResult<IQuantity> TOTAL_DUPLICATED_FLAGS = new TypedResult("totalDuplicatedFlags", Messages.getString("DuplicateFlagsRule_RESULT_DUPLICATED_FLAGS_COUNT_NAME"), Messages.getString("DuplicateFlagsRule_RESULT_DUPLICATED_FLAGS_COUNT_DESCRIPTION"), (ContentType)UnitLookup.NUMBER, IQuantity.class);
    private static final List<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(DUPLICATED_FLAGS, TOTAL_DUPLICATED_FLAGS);

    public String getId() {
        return RESULT_ID;
    }

    public String getTopic() {
        return "jvm_information";
    }

    public String getName() {
        return Messages.getString("DuplicateFlagsRuleFactory_RULE_NAME");
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider preferenceValueProvider, final IResultValueProvider dependencyResults) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return DuplicateFlagsRule.this.getResult(items, preferenceValueProvider, dependencyResults);
            }
        });
        return evaluationTask;
    }

    private IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        IAggregator argumentAggregator;
        IItemCollection jvmInfoItems = items.apply(JdkFilters.VM_INFO);
        Set args = (Set)jvmInfoItems.getAggregate(argumentAggregator = Aggregators.distinct((IAttribute)JdkAttributes.JVM_ARGUMENTS));
        if (args != null && !args.isEmpty()) {
            ArrayList<DuplicateFlags> duplicateFlags = new ArrayList<DuplicateFlags>();
            for (List list : JvmInternalsDataProvider.checkDuplicates((String)args.iterator().next())) {
                duplicateFlags.add(new DuplicateFlags(list));
            }
            if (!JvmInternalsDataProvider.checkDuplicates((String)args.iterator().next()).isEmpty()) {
                return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).addResult(DUPLICATED_FLAGS, duplicateFlags).addResult(TOTAL_DUPLICATED_FLAGS, (Object)UnitLookup.NUMBER_UNITY.quantity((long)duplicateFlags.size())).setSeverity(Severity.INFO).setSummary(Messages.getString("DuplicateFlagsRule_RESULT_SUMMARY")).setExplanation(Messages.getString("DuplicateFlagsRule_RESULT_EXPLANATION")).setSolution(Messages.getString("DuplicateFlagsRule_RESULT_SOLUTION")).build();
            }
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary(Messages.getString("DuplicateFlagsRule_RESULT_SUMMARY_OK")).build();
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }

    static {
        REQUIRED_EVENTS.put("jdk.JVMInformation", RulesToolkit.EventAvailability.AVAILABLE);
    }

    public static class DuplicateFlags
    implements IDisplayable {
        private final List<String> duplicates;

        private DuplicateFlags(List<String> duplicates) {
            this.duplicates = duplicates;
        }

        public String displayUsing(String formatHint) {
            StringBuilder sb = new StringBuilder();
            for (String d : this.duplicates) {
                sb.append(d);
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
    }
}

