/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.ui.attributes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.openjdk.jmc.rjmx.subscription.internal.UpdatePolicyToolkit;
import org.openjdk.jmc.rjmx.ui.attributes.Messages;
import org.openjdk.jmc.rjmx.ui.attributes.ReadOnlyMRIAttribute;
import org.openjdk.jmc.rjmx.ui.attributes.UpdateIntervalDialog;

public class UpdateIntervalManager {
    private final MenuManager m_updateMenu = new MenuManager(Messages.UpdateIntervalManager_CHANGE_UPDATE_INTERVAL_MENU_ITEM);

    public UpdateIntervalManager(TreeViewer viewer) {
        this.setupUpdateIntervalMenu(viewer);
    }

    private MenuManager setupUpdateIntervalMenu(final TreeViewer viewer) {
        this.m_updateMenu.add((IAction)this.createUpdateAction(Messages.MRIAttributeInspector_UPDATE_INTERVAL_DEFAULT, viewer, -1));
        this.m_updateMenu.add((IAction)this.createUpdateAction(Messages.MRIAttributeInspector_UPDATE_INTERVAL_ONCE, viewer, 0));
        this.m_updateMenu.add((IAction)new Action(Messages.UpdateIntervalManager_CUSTOM_UPDATE_INTERVAL_MENU_ITEM){

            public void run() {
                UpdateIntervalDialog dialog = new UpdateIntervalDialog(viewer.getControl().getShell(), this.getCurrentUpdateInterval());
                if (dialog.open() == 0) {
                    UpdateIntervalManager.this.applyUpdateInterval(viewer, dialog.getUpdateInterval());
                }
            }

            private int getCurrentUpdateInterval() {
                int updateInterval = -1;
                boolean firstInterval = true;
                for (ReadOnlyMRIAttribute attribute : UpdateIntervalManager.this.getSelectedAttributes(viewer)) {
                    int interval = attribute.getUpdateInterval();
                    if (firstInterval) {
                        updateInterval = interval;
                        firstInterval = false;
                        continue;
                    }
                    if (updateInterval == interval) continue;
                    updateInterval = -1;
                    break;
                }
                if (updateInterval == -1 || updateInterval == 0) {
                    updateInterval = UpdatePolicyToolkit.getDefaultUpdateInterval();
                }
                return updateInterval;
            }
        });
        return this.m_updateMenu;
    }

    private Action createUpdateAction(String label, final TreeViewer viewer, final int updateTime) {
        return new Action(label){

            public void run() {
                UpdateIntervalManager.this.applyUpdateInterval(viewer, updateTime);
            }
        };
    }

    private void applyUpdateInterval(TreeViewer viewer, int updateInterval) {
        for (ReadOnlyMRIAttribute attribute : this.getSelectedAttributes(viewer)) {
            attribute.setUpdateInterval(updateInterval);
            viewer.refresh((Object)attribute);
        }
    }

    private List<ReadOnlyMRIAttribute> getSelectedAttributes(TreeViewer viewer) {
        ArrayList<ReadOnlyMRIAttribute> attributes = new ArrayList<ReadOnlyMRIAttribute>();
        for (Object o : ((IStructuredSelection)viewer.getSelection()).toList()) {
            if (!(o instanceof ReadOnlyMRIAttribute)) continue;
            attributes.add((ReadOnlyMRIAttribute)((Object)o));
        }
        return attributes;
    }

    public MenuManager getUpdateIntervalMenu() {
        return this.m_updateMenu;
    }
}

