/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.jolokia;

import java.util.Arrays;
import java.util.TreeSet;
import org.jolokia.server.core.config.ConfigKey;
import org.jolokia.server.core.config.Configuration;
import org.jolokia.server.core.config.StaticConfiguration;
import org.jolokia.server.core.detector.ServerDetector;
import org.jolokia.server.core.restrictor.AllowAllRestrictor;
import org.jolokia.server.core.service.JolokiaServiceManagerFactory;
import org.jolokia.server.core.service.api.JolokiaContext;
import org.jolokia.server.core.service.api.JolokiaServiceManager;
import org.jolokia.server.core.service.api.LogHandler;
import org.jolokia.server.core.service.api.Restrictor;
import org.jolokia.server.core.service.impl.JulLogHandler;
import org.openjdk.jmc.jolokia.JolokiaDiscoverySettings;
import org.openjdk.jmc.jolokia.preferences.PreferenceConstants;
import org.openjdk.jmc.ui.MCAbstractUIPlugin;

public class JmcJolokiaPlugin
extends MCAbstractUIPlugin
implements JolokiaDiscoverySettings,
PreferenceConstants {
    public static final String PLUGIN_ID = "org.openjdk.jmc.jolokia";
    private static JmcJolokiaPlugin plugin;

    public JmcJolokiaPlugin() {
        super(PLUGIN_ID);
        plugin = this;
    }

    public static JmcJolokiaPlugin getDefault() {
        return plugin;
    }

    @Override
    public boolean shouldRunDiscovery() {
        return this.getPreferenceStore().getBoolean("discoverJolokia");
    }

    @Override
    public JolokiaContext getJolokiaContext() {
        StaticConfiguration configuration = new StaticConfiguration(new Object[]{ConfigKey.AGENT_ID, "jmc"});
        JolokiaServiceManager serviceManager = JolokiaServiceManagerFactory.createJolokiaServiceManager((Configuration)configuration, (LogHandler)new JulLogHandler(PLUGIN_ID), (Restrictor)new AllowAllRestrictor(), () -> new TreeSet<ServerDetector>(Arrays.asList(ServerDetector.FALLBACK)));
        return serviceManager.start();
    }

    @Override
    public String getMulticastGroup() {
        return this.getPreferenceStore().getString("multicastGroup");
    }

    @Override
    public int getMulticastPort() {
        return this.getPreferenceStore().getInt("multicastPort");
    }

    @Override
    public int getDiscoveryTimeout() {
        return this.getPreferenceStore().getInt("discoverTimeout");
    }
}

