/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.common.services.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.common.RJMXCorePlugin;
import org.openjdk.jmc.rjmx.common.services.IDummyService;
import org.openjdk.jmc.rjmx.common.services.internal.ServiceEntry;

public class ServiceFactoryManager {
    private static final Map<Class<?>, Collection<? extends ServiceEntry<?>>> factoryMap = new HashMap();

    private Logger getLogger() {
        return RJMXCorePlugin.getDefault().getLogger();
    }

    public static <T> T createDummyService(Class<T> serviceInterface, Throwable cause) {
        Class[] interfaces = new Class[]{serviceInterface, IDummyService.class};
        ClassLoader cl = serviceInterface.getClassLoader();
        return (T)Proxy.newProxyInstance(cl == null ? IDummyService.class.getClassLoader() : cl, interfaces, (InvocationHandler)new UnsupportedInvocationHandler(cause));
    }

    public <T> T createService(Class<T> serviceClass, IConnectionHandle handle) {
        T firstDummyService = null;
        Exception firstException = null;
        for (ServiceEntry<T> entry : this.getFactoriesFor(serviceClass)) {
            try {
                T service = entry.getServiceFactory().getServiceInstance(handle);
                if (service == null) continue;
                if (!ServiceFactoryManager.isDummy(service)) {
                    return service;
                }
                if (firstDummyService != null) continue;
                firstDummyService = service;
            }
            catch (Exception e) {
                if (firstException == null) {
                    firstException = e;
                }
                this.getLogger().log(Level.FINE, "Could not create service!", e);
            }
        }
        if (firstDummyService == null && firstException != null && serviceClass.isInterface()) {
            try {
                firstDummyService = ServiceFactoryManager.createDummyService(serviceClass, firstException);
            }
            catch (Exception e) {
                this.getLogger().log(Level.FINE, "Could not create dummy service to wrap exception!", e);
            }
        }
        return firstDummyService;
    }

    public static boolean isDummy(Object service) {
        return service instanceof IDummyService;
    }

    private <T> Collection<ServiceEntry<T>> getFactoriesFor(Class<T> clazz) {
        Collection<ServiceEntry<T>> factories = factoryMap.get(clazz);
        if (factories == null) {
            factories = Collections.emptyList();
        }
        return factories;
    }

    public void initializeFromExtensions(List<ServiceEntry<?>> serviceEntries) {
        for (ServiceEntry<?> service : serviceEntries) {
            this.registerService(service);
        }
    }

    private <T> void registerService(ServiceEntry<T> entry) {
        Collection<Object> factories;
        Class<T> serviceClass = entry.getServiceClass();
        if (factoryMap.containsKey(serviceClass)) {
            factories = this.getFactoriesFor(entry.getServiceClass());
        } else {
            factories = new ArrayList();
            factoryMap.put(entry.getServiceClass(), factories);
        }
        factories.add(entry);
    }

    private static class UnsupportedInvocationHandler
    implements InvocationHandler {
        private final Throwable cause;

        public UnsupportedInvocationHandler(Throwable cause) {
            this.cause = cause;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object msg = this.cause != null && this.cause.getMessage() != null ? this.cause.getMessage() : "Does not support method " + method.getName();
            throw new UnsupportedOperationException((String)msg, this.cause);
        }
    }
}

