/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.providers;

import org.openjdk.jmc.greychart.impl.SamplePoint;
import org.openjdk.jmc.greychart.providers.AbstractSampler;

public class IntegratingSubsamplingBuffer
extends AbstractSampler {
    public IntegratingSubsamplingBuffer(int size) {
        super(size);
    }

    public void addDataPoint(double normalizedStartX, double normalizedEndX, double value) {
        if (normalizedStartX < 0.0 || normalizedStartX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedStartX);
        }
        if (normalizedEndX < 0.0 || normalizedEndX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedEndX);
        }
        this.addStartSamplePoint((double)this.getSize() * normalizedStartX, value);
        this.addEndSamplePoint(Math.max((double)this.getSize() * normalizedEndX, (double)this.getSize() * normalizedStartX + 1.0), -value);
    }

    protected void addStartSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.getSize()) {
            SamplePoint sp = this.getSamplePoint(currentIndex);
            ++sp.count;
            sp.y += currentY;
            sp.max = Math.max(currentY, sp.max);
        }
    }

    protected void addEndSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.getSize()) {
            SamplePoint sp = this.getSamplePoint(currentIndex);
            ++sp.count;
            sp.y += currentY;
        }
    }

    public void fixSamples() {
        double currentSum = 0.0;
        double currentY = 0.0;
        SamplePoint[] samplePointArray = this.getSamples();
        int n = samplePointArray.length;
        int n2 = 0;
        while (n2 < n) {
            SamplePoint sp = samplePointArray[n2];
            if (sp != null) {
                sp.min = 0.0;
                double maxY = sp.max;
                double incY = sp.y;
                double oldY = currentY;
                double maxNewY = Math.max(currentY, maxY);
                currentY = Math.min(maxNewY, currentSum += incY);
                sp.y = oldY;
                sp.yOut = currentY;
                sp.count = 2L;
            }
            ++n2;
        }
        if (this.getSize() > 0 && this.getSamples()[this.getSize() - 1] == null && currentY > 0.0) {
            SamplePoint point = this.getSamplePoint(this.getSize() - 1);
            point.y = currentY;
            point.yOut = currentY;
            point.count = 1L;
        }
        this.invalidateStatistics();
    }
}

