/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import net.jpountz.lz4.LZ4FrameInputStream;

public final class IOToolkit {
    private static final int[] MAGIC_ZIP = new int[]{80, 75, 3, 4};
    private static final int[] MAGIC_GZ = new int[]{31, 139};
    private static final int[] MAGIC_LZ4 = new int[]{4, 34, 77, 24};

    private IOToolkit() {
        throw new Error("Don't");
    }

    public static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static InputStream openUncompressedStream(File file) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        try {
            BufferedInputStream in = new BufferedInputStream(fin);
            if (IOToolkit.hasMagic(file, MAGIC_GZ)) {
                return new GZIPInputStream(in);
            }
            if (IOToolkit.hasMagic(file, MAGIC_ZIP)) {
                ZipInputStream zin = new ZipInputStream(in);
                zin.getNextEntry();
                return zin;
            }
            if (IOToolkit.hasMagic(file, MAGIC_LZ4)) {
                return new LZ4FrameInputStream((InputStream)in);
            }
            return in;
        }
        catch (RuntimeException e) {
            IOToolkit.closeSilently(fin);
            throw e;
        }
        catch (IOException e) {
            IOToolkit.closeSilently(fin);
            throw e;
        }
        catch (Error e) {
            IOToolkit.closeSilently(fin);
            throw e;
        }
    }

    public static InputStream openUncompressedStream(InputStream stream) throws IOException {
        BufferedInputStream in = new BufferedInputStream(stream);
        ((InputStream)in).mark(MAGIC_GZ.length + 1);
        if (IOToolkit.hasMagic(in, MAGIC_GZ)) {
            ((InputStream)in).reset();
            return new GZIPInputStream(in);
        }
        ((InputStream)in).reset();
        ((InputStream)in).mark(MAGIC_ZIP.length + 1);
        if (IOToolkit.hasMagic(in, MAGIC_ZIP)) {
            ((InputStream)in).reset();
            ZipInputStream zin = new ZipInputStream(in);
            zin.getNextEntry();
            return zin;
        }
        ((InputStream)in).reset();
        ((InputStream)in).mark(MAGIC_LZ4.length + 1);
        if (IOToolkit.hasMagic(in, MAGIC_LZ4)) {
            ((InputStream)in).reset();
            return new LZ4FrameInputStream((InputStream)in);
        }
        ((InputStream)in).reset();
        return in;
    }

    public static boolean hasMagic(File file, int[] magic) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            boolean bl = IOToolkit.hasMagic(fis, magic);
            return bl;
        }
    }

    public static boolean hasMagic(InputStream is, int[] magic) throws IOException {
        for (int element : magic) {
            int b = is.read();
            if (b == element) continue;
            return false;
        }
        return true;
    }

    public static boolean isGZipFile(File file) throws IOException {
        return IOToolkit.hasMagic(file, MAGIC_GZ);
    }

    public static boolean isLZ4File(File file) throws IOException {
        return IOToolkit.hasMagic(file, MAGIC_LZ4);
    }

    public static boolean isZipFile(File file) throws IOException {
        return IOToolkit.hasMagic(file, MAGIC_ZIP);
    }

    public static int[] getGzipMagic() {
        return (int[])MAGIC_GZ.clone();
    }

    public static int[] getZipMagic() {
        return (int[])MAGIC_ZIP.clone();
    }

    public static int[] getLz4Magic() {
        return (int[])MAGIC_LZ4.clone();
    }

    public static boolean isCompressedFile(File file) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file), MAGIC_ZIP.length + 1);){
            is.mark(MAGIC_ZIP.length + 1);
            if (IOToolkit.hasMagic(is, MAGIC_GZ)) {
                boolean bl = true;
                return bl;
            }
            is.reset();
            if (IOToolkit.hasMagic(is, MAGIC_ZIP)) {
                boolean bl = true;
                return bl;
            }
            is.reset();
            boolean bl = IOToolkit.hasMagic(is, MAGIC_LZ4);
            return bl;
        }
    }

    public static List<String> loadFromFile(File file) throws IOException {
        try (FileReader fr = new FileReader(file);){
            List<String> list = IOToolkit.loadFromReader(fr);
            return list;
        }
    }

    private static List<String> loadFromReader(Reader reader) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(reader);){
            while (br.ready()) {
                lines.add(br.readLine());
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    public static void saveToFile(File file, List<String> lines) throws IOException {
        try (PrintWriter pr = new PrintWriter(new FileWriter(file));){
            for (String line : lines) {
                pr.println(line);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static List<String> loadFromStream(InputStream is) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void write(InputStream in, File toOutput, boolean append) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(toOutput, append);
             BufferedOutputStream os = new BufferedOutputStream(fos);){
            IOToolkit.copy(in, os);
        }
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        IOToolkit.copy(is, os, 1024);
    }

    public static void copy(InputStream is, OutputStream os, int bufferSize) throws IOException {
        int length;
        byte[] buffer = new byte[bufferSize];
        while ((length = is.read(buffer)) > 0) {
            os.write(buffer, 0, length);
        }
        is.close();
    }

    public static void copyFile(File srcFile, File targetFile) throws IOException {
        Files.copy(srcFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
    }

    public static String calculateFileHash(File file) throws IOException {
        String string;
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            int read;
            long seek = raf.length() / 10L;
            byte[] buffer = new byte[1024];
            MessageDigest hash = MessageDigest.getInstance("MD5");
            while ((read = raf.read(buffer)) > 0) {
                hash.update(buffer, 0, read);
                raf.seek(raf.getFilePointer() + seek);
            }
            string = new BigInteger(1, hash.digest()).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    raf.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        raf.close();
        return string;
    }
}

