/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class SocketReadRule
implements IRule {
    private static final String RESULT_ID = "SocketRead";
    public static final TypedPreference<IQuantity> READ_INFO_LIMIT = new TypedPreference("io.socket.read.info.limit", Messages.getString("SocketReadRule_CONFIG_INFO_LIMIT"), Messages.getString("SocketReadRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(275L));
    public static final TypedPreference<IQuantity> READ_WARNING_LIMIT = new TypedPreference("io.socket.read.warning.limit", Messages.getString("SocketReadRule_CONFIG_WARNING_LIMIT"), Messages.getString("SocketReadRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(2000L));
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.SocketRead", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final TypedResult<IQuantity> LONGEST_READ_AMOUNT = new TypedResult("longestReadAmount", "Longest Read (Amount)", "The amount read for the longest socket read.", (ContentType)UnitLookup.MEMORY, IQuantity.class);
    public static final TypedResult<IQuantity> LONGEST_READ_TIME = new TypedResult("longestReadTime", "Longest Read (Time)", "The longest time it took to perform a socket read.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<String> LONGEST_READ_ADDRESS = new TypedResult("longestReadHost", "Longest Read (Host)", "The remote host of the socket read that took the longest time.", UnitLookup.PLAIN_TEXT, String.class);
    public static final TypedResult<IQuantity> LONGEST_TOTAL_READ = new TypedResult("totalReadForLongest", "Total Read (Top Host)", "The total duration of all socket reads for the host with the longest read.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> AVERAGE_SOCKET_READ = new TypedResult("averageSocketRead", "Average Socket Read", "The average duration of all socket reads.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> TOTAL_SOCKET_READ = new TypedResult("totalSocketRead", "Total Socket Read", "The total duration of all socket reads.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, LONGEST_READ_ADDRESS, LONGEST_READ_AMOUNT, LONGEST_READ_TIME, LONGEST_TOTAL_READ, AVERAGE_SOCKET_READ, TOTAL_SOCKET_READ);
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(READ_INFO_LIMIT, READ_WARNING_LIMIT);

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider vp, final IResultValueProvider rp) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return SocketReadRule.this.evaluate(items, vp, rp);
            }
        });
        return evaluationTask;
    }

    private IResult evaluate(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        IQuantity infoLimit = (IQuantity)vp.getPreferenceValue(READ_INFO_LIMIT);
        IQuantity warningLimit = (IQuantity)vp.getPreferenceValue(READ_WARNING_LIMIT);
        IItemCollection readItems = items.apply(JdkFilters.NO_RMI_SOCKET_READ);
        IType readType = RulesToolkit.getType((IItemCollection)readItems, (String)"jdk.SocketRead");
        if (!readType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.IO_ADDRESS)) {
            return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)readType, (IAttribute)JdkAttributes.IO_ADDRESS, (IPreferenceValueProvider)vp);
        }
        IItem longestEvent = (IItem)readItems.getAggregate(Aggregators.itemWithMax((IAttribute)JfrAttributes.DURATION));
        if (longestEvent == null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary("SocketReadRuleFactory_TEXT_NO_EVENTS").setExplanation(Messages.getString("SocketReadRuleFactory_TEXT_RMI_NOTE")).build();
        }
        IQuantity maxDuration = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.DURATION);
        double score = RulesToolkit.mapExp100((double)maxDuration.doubleValueIn((IUnit)UnitLookup.SECOND), (double)infoLimit.doubleValueIn((IUnit)UnitLookup.SECOND), (double)warningLimit.doubleValueIn((IUnit)UnitLookup.SECOND));
        Severity severity = Severity.get((double)score);
        if (severity == Severity.WARNING || severity == Severity.INFO) {
            String address = (String)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_ADDRESS);
            if (address == null || address.isEmpty()) {
                address = Messages.getString("General_UNKNOWN_ADDRESS");
            }
            IQuantity amountRead = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_SOCKET_BYTES_READ);
            IQuantity avgDuration = (IQuantity)readItems.getAggregate(Aggregators.avg((String)"jdk.SocketRead", (IAttribute)JfrAttributes.DURATION));
            IQuantity totalDuration = (IQuantity)readItems.getAggregate(Aggregators.sum((String)"jdk.SocketRead", (IAttribute)JfrAttributes.DURATION));
            IItemCollection eventsFromLongestAddress = readItems.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.IO_ADDRESS, (Object)address));
            IQuantity totalLongestIOAddress = (IQuantity)eventsFromLongestAddress.getAggregate(Aggregators.sum((String)"jdk.SocketRead", (IAttribute)JfrAttributes.DURATION));
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(severity).setSummary(Messages.getString("SocketReadRuleFactory_TEXT_WARN")).setExplanation(Messages.getString("SocketReadRuleFactory_TEXT_WARN_LONG") + " " + Messages.getString("SocketReadRuleFactory_TEXT_RMI_NOTE")).addResult(LONGEST_READ_ADDRESS, (Object)address).addResult(LONGEST_READ_AMOUNT, (Object)amountRead).addResult(LONGEST_TOTAL_READ, (Object)totalLongestIOAddress).addResult(AVERAGE_SOCKET_READ, (Object)avgDuration).addResult(TOTAL_SOCKET_READ, (Object)totalDuration).addResult(LONGEST_READ_TIME, (Object)maxDuration).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(severity).setSummary(Messages.getString("SocketReadRuleFactory_TEXT_OK")).setExplanation(Messages.getString("SocketReadRuleFactory_TEXT_RMI_NOTE")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(LONGEST_READ_TIME, (Object)maxDuration).build();
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("SocketReadRuleFactory_RULE_NAME");
    }

    protected static String sanitizeAddress(String address) {
        if (address == null || address.isEmpty()) {
            Messages.getString("General_UNKNOWN_ADDRESS");
        }
        return address;
    }

    public String getTopic() {
        return "socket_io";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

