/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.mbeanbrowser.tree;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.openjdk.jmc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import org.openjdk.jmc.console.ui.mbeanbrowser.messages.internal.Messages;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.ui.wizards.IPerformFinishable;
import org.osgi.service.prefs.Preferences;

public class AddMBeanWizardPage
extends WizardPage
implements IPerformFinishable {
    private static final String ADD_MBEAN_WIZARD_SETTINGS = "AddMBeanWizardPage";
    private static final String MBEAN_CLASS_NAME_KEY = "MBeanClassName";
    private static final String DEFAULT_MBEAN_CLASS_NAME = "com.sun.management.MissionControl";
    private static final String MBEAN_OBJECT_NAME_KEY = "MBeanObjectName";
    private static final String DEFAULT_MBEAN_OBJECT_NAME = "com.sun.management:type=MissionControl";
    private final MBeanServerConnection mbeanServerConnection;
    private final String connectionGUID;
    private Text objectNameField;
    private Text classNameField;

    public AddMBeanWizardPage(MBeanServerConnection connection, String guid) {
        super(Messages.ADD_MBEAN_LABEL);
        this.mbeanServerConnection = connection;
        this.connectionGUID = guid;
        this.setImageDescriptor(MBeanBrowserPlugin.getDefault().getImageRegistry().getDescriptor("create-mbean-wiz.png"));
        this.setDescription(Messages.ADD_MBEAN_LONG_DESCRIPTION);
        this.setTitle(Messages.ADD_MBEAN_TITLE);
    }

    public boolean performFinish() {
        try {
            this.mbeanServerConnection.createMBean(this.getMBeanClassName(), this.getValidObjectName());
            this.storeWizardSettings();
            return true;
        }
        catch (Exception e) {
            this.setErrorMessage(NLS.bind((String)Messages.UNABLE_TO_CREATE_MBEAN_MESSAGE, (Object)e.getClass().getName(), (Object)e.getLocalizedMessage()));
            return false;
        }
    }

    private void checkPageComplete() {
        if (this.getValidObjectName() == null) {
            this.setErrorMessage(NLS.bind((String)Messages.INVALID_MBEAN_NAME_MESSAGE, (Object)this.objectNameField.getText()));
            this.setPageComplete(false);
            return;
        }
        if (this.getMBeanClassName().isEmpty()) {
            this.setErrorMessage(Messages.INVALID_EMPTY_CLASS_NAME);
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private ObjectName getValidObjectName() {
        String name = this.objectNameField.getText();
        if (name.isEmpty()) {
            return null;
        }
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            return null;
        }
    }

    private String getMBeanClassName() {
        return this.classNameField.getText().trim();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)container);
        this.addLabel(container, Messages.MBEAN_OBJECT_NAME_LABEL);
        this.objectNameField = this.createField(container, DEFAULT_MBEAN_OBJECT_NAME);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddMBeanWizardPage.this.checkPageComplete();
            }
        };
        this.objectNameField.addModifyListener(listener);
        this.addLabel(container, Messages.MBEAN_CLASS_NAME_LABEL);
        this.classNameField = this.createField(container, DEFAULT_MBEAN_CLASS_NAME);
        this.classNameField.addModifyListener(listener);
        this.readWizardSettings();
        this.checkPageComplete();
    }

    private Text createField(Composite container, String defaultText) {
        Text field = new Text(container, 2626);
        field.setText(defaultText);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.widthHint = 400;
        field.setLayoutData((Object)gd);
        return field;
    }

    private void addLabel(Composite container, String label) {
        Label objectNameLabel = new Label(container, 0);
        objectNameLabel.setText(label);
        objectNameLabel.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
    }

    private void readWizardSettings() {
        try {
            String cn;
            XMLMemento state = XMLMemento.createReadRoot((Reader)new StringReader(this.getServerPreferencesForConnection().get(ADD_MBEAN_WIZARD_SETTINGS, "")));
            String on = state.getString(MBEAN_OBJECT_NAME_KEY);
            if (on != null) {
                this.objectNameField.setText(on);
            }
            if ((cn = state.getString(MBEAN_CLASS_NAME_KEY)) != null) {
                this.classNameField.setText(cn);
            }
        }
        catch (WorkbenchException workbenchException) {}
    }

    private Preferences getServerPreferencesForConnection() {
        return RJMXPlugin.getDefault().getServerPreferences(this.connectionGUID);
    }

    private void storeWizardSettings() {
        XMLMemento state = XMLMemento.createWriteRoot((String)ADD_MBEAN_WIZARD_SETTINGS);
        state.putString(MBEAN_OBJECT_NAME_KEY, this.objectNameField.getText());
        state.putString(MBEAN_CLASS_NAME_KEY, this.classNameField.getText());
        StringWriter sw = new StringWriter();
        try {
            state.save((Writer)sw);
        }
        catch (IOException iOException) {}
        this.getServerPreferencesForConnection().put(ADD_MBEAN_WIZARD_SETTINGS, sw.toString());
    }
}

