/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.Attribute;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class FastTimeRule
implements IRule {
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.CPUTimeStampCounter", RulesToolkit.EventAvailability.AVAILABLE).build();

    public String getId() {
        return "FastTimeRule";
    }

    public String getTopic() {
        return "jvm_information";
    }

    public String getName() {
        return "Fast Time Conversion Rule";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    private IResult getResult(IItemCollection items, IPreferenceValueProvider preferences, IResultValueProvider results) {
        IItemCollection timeConversionItems = items.apply(JdkFilters.TIME_CONVERSION);
        IAggregator max = Aggregators.max((IAttribute)Attribute.attr((String)"fastTimeConversionAdjustments", null, (ContentType)UnitLookup.NUMBER));
        IQuantity conversionFactor = (IQuantity)timeConversionItems.getAggregate(max);
        Boolean fastTimeEnabled = (Boolean)timeConversionItems.getAggregate(Aggregators.and((String)"jdk.CPUTimeStampCounter", (IAttribute)Attribute.attr((String)"fastTimeEnabled", null, (ContentType)UnitLookup.FLAG)));
        if (conversionFactor != null && fastTimeEnabled.booleanValue() && conversionFactor.longValue() != 0L) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)preferences).setSeverity(Severity.WARNING).setSummary(Messages.getString("FasttimeRule_TEXT_WARN")).setExplanation(Messages.getString("FasttimeRule_TEXT_WARN_LONG")).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)preferences).setSeverity(Severity.OK).setSummary(Messages.getString("FlightRecordingSupportRule_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider preferenceValueProvider, final IResultValueProvider dependencyResults) {
        return new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return FastTimeRule.this.getResult(items, preferenceValueProvider, dependencyResults);
            }
        });
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public Collection<TypedResult<?>> getResults() {
        return Collections.emptyList();
    }
}

