/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.logging.Logger;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class PID1Rule
implements IRule {
    private static final String PID1Rule_RESULT_ID = "PID1Rule";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.JVMInformation", RulesToolkit.EventAvailability.AVAILABLE).build();

    public String getId() {
        return PID1Rule_RESULT_ID;
    }

    public String getTopic() {
        return "jvm_information";
    }

    public String getName() {
        return Messages.getString("PID1Rule_RULE_NAME");
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public RunnableFuture<IResult> createEvaluation(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        return new FutureTask<IResult>(() -> this.getResult(items, valueProvider));
    }

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider) {
        IAggregator distinct;
        IItemCollection vmInfoEvents = items.apply(ItemFilters.type((String)"jdk.JVMInformation"));
        Set aggregate = (Set)vmInfoEvents.getAggregate(distinct = Aggregators.distinct((IAttribute)JdkAttributes.PID));
        if (aggregate == null || aggregate.isEmpty()) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.IGNORE).setSummary(Messages.getString("PID1Rule_NO_PID")).build();
        }
        if (aggregate.size() > 1) {
            String warningMessage = "There is more than one PID information available. This should not be possible.";
            Logger.getLogger(this.getClass().getName()).warning(warningMessage);
            return RulesToolkit.getNotApplicableResult((IRule)this, (IPreferenceValueProvider)valueProvider, (String)warningMessage);
        }
        String pid = (String)aggregate.iterator().next();
        if ("1".equals(pid)) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.WARNING).setSummary(Messages.getString("PID1Rule_TEXT_INFO")).setExplanation(Messages.getString("PID1Rule_TEXT_INFO_LONG")).setSolution(Messages.getString("PID1Rule_TEXT_SOLUTION")).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary("PID1Rule_TEXT_OK").build();
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public Collection<TypedResult<?>> getResults() {
        return Collections.emptyList();
    }
}

