/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.memleak.ReferenceTreeModel;
import org.openjdk.jmc.flightrecorder.memleak.ReferenceTreeObject;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class IncreasingLiveSetRule
implements IRule {
    private static final double PERCENT_OF_HEAP_INCREASE_PER_SECOND = 0.01;
    private static final String RESULT_ID = "IncreasingLiveSet";
    public static final TypedPreference<IQuantity> CLASSES_LOADED_PERCENT = new TypedPreference("memleak.classload.percent", Messages.getString("IncreasingLiveSetRule_LOADED_CLASSES_PERCENT"), Messages.getString("IncreasingLiveSetRule_LOADED_CLASSES_PERCENT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(90L));
    public static final TypedPreference<IQuantity> RELEVANCE_THRESHOLD = new TypedPreference("memleak.reference.tree.depth", Messages.getString("IncreasingLiveSetRule_RELEVANCE_THRESHOLD"), Messages.getString("IncreasingLiveSetRule_RELEVANCE_THRESHOLD_DESC"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.5));
    public static final TypedPreference<IQuantity> YOUNG_COLLECTION_THRESHOLD = new TypedPreference("memleak.young.collections", Messages.getString("IncreasingLiveSetRule_YOUNG_COLLECTION_THRESHOLD"), Messages.getString("IncreasingLiveSetRule_YOUNG_COLLECTION_THRESHOLD_DESC"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(4L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(CLASSES_LOADED_PERCENT, RELEVANCE_THRESHOLD, YOUNG_COLLECTION_THRESHOLD);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.GCHeapSummary", RulesToolkit.EventAvailability.ENABLED).build();
    public static final ContentType<ReferenceTreeObject> REFERENCE_TREE_OBJECT = UnitLookup.createSyntheticContentType((String)"referenceTreeObject");
    public static final TypedResult<IQuantity> LIVESET_INCREASE = new TypedResult("livesetIncrease", "Liveset Increase", "The speed of the liveset increase per second.", (ContentType)UnitLookup.MEMORY, IQuantity.class);
    public static final TypedResult<IQuantity> TIME_AFTER_JVM_START = new TypedResult("timeAfterJvmStart", "Time After JVM Start", "The time since the JVM was started.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> LEAK_CANDIDATE_COUNT = new TypedResult("leakCandidateCount", "Leak Candidate Count", "The number of leak candidates detected.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<ReferenceTreeObject> LEAK_CANDIDATE = new TypedResult("leakCandidate", "Leak Candidate", "The main leak candidate detected.", REFERENCE_TREE_OBJECT, ReferenceTreeObject.class);
    public static final TypedCollectionResult<ReferenceTreeObject> REFERENCE_CHAIN = new TypedCollectionResult("referenceChain", "Reference Chain", "The objects keeping the main leak candidate alive.", REFERENCE_TREE_OBJECT, ReferenceTreeObject.class);
    public static final TypedResult<IQuantity> POST_WARMUP_TIME = new TypedResult("postWarmupTime", "Post Warmup Time", "The time after which the rule assumes that long lived objects aren't supposed to be allocated.", (ContentType)UnitLookup.TIMESTAMP, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, LIVESET_INCREASE, TIME_AFTER_JVM_START, LEAK_CANDIDATE_COUNT, LEAK_CANDIDATE, REFERENCE_CHAIN, POST_WARMUP_TIME);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IQuantity postWarmupTime = this.getPostWarmupTime(items, (IQuantity)valueProvider.getPreferenceValue(CLASSES_LOADED_PERCENT));
        Iterator allAfterItems = items.apply(JdkFilters.HEAP_SUMMARY_AFTER_GC).iterator();
        double score = 0.0;
        ITypedQuantity liveSetIncreasePerSecond = UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.MEBI).quantity(0L);
        if (allAfterItems.hasNext()) {
            IItemIterable afterItems = (IItemIterable)allAfterItems.next();
            IMemberAccessor timeAccessor = JfrAttributes.END_TIME.getAccessor(afterItems.getType());
            IMemberAccessor memAccessor = JdkAttributes.HEAP_USED.getAccessor(afterItems.getType());
            liveSetIncreasePerSecond = UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.MEBI).quantity(RulesToolkit.leastSquareMemory((Iterator)afterItems.iterator(), (IMemberAccessor)timeAccessor, (IMemberAccessor)memAccessor));
            if (postWarmupTime == null) {
                return RulesToolkit.getTooFewEventsResult((IRule)this, (IPreferenceValueProvider)valueProvider);
            }
            IQuantity postWarmupHeapSize = (IQuantity)items.apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.HEAP_SUMMARY_AFTER_GC, ItemFilters.moreOrEqual((ICanonicalAccessorFactory)JfrAttributes.START_TIME, (Comparable)postWarmupTime)})).getAggregate(JdkAggregators.first((IAttribute)JdkAttributes.HEAP_USED));
            if (postWarmupHeapSize == null) {
                return RulesToolkit.getTooFewEventsResult((IRule)this, (IPreferenceValueProvider)valueProvider);
            }
            double relativeIncreasePerSecond = liveSetIncreasePerSecond.ratioTo(postWarmupHeapSize);
            score = RulesToolkit.mapExp100((double)relativeIncreasePerSecond, (double)0.01);
        }
        IQuantity youngCollections = (IQuantity)items.getAggregate(Aggregators.count((IItemFilter)ItemFilters.type((String)"jdk.YoungGarbageCollection")));
        IQuantity oldCollections = (IQuantity)items.getAggregate(Aggregators.count((IItemFilter)JdkFilters.OLD_GARBAGE_COLLECTION));
        if (oldCollections.longValue() == 0L) {
            if (youngCollections.longValue() <= ((IQuantity)valueProvider.getPreferenceValue(YOUNG_COLLECTION_THRESHOLD)).longValue()) {
                return RulesToolkit.getTooFewEventsResult((IRule)this, (IPreferenceValueProvider)valueProvider);
            }
            score = Math.min(score, 74.0);
        }
        RulesToolkit.EventAvailability ea = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])new String[]{"jdk.OldObjectSample"});
        IQuantity timeAfterJVMStart = RulesToolkit.getEarliestStartTime((IItemCollection)items).subtract((IQuantity)items.getAggregate(JdkAggregators.JVM_START_TIME));
        if (ea == RulesToolkit.EventAvailability.DISABLED || ea == RulesToolkit.EventAvailability.UNKNOWN) {
            if (score >= 25.0) {
                return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("IncreasingLiveSetRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("IncreasingLiveSetRuleFactory_TEXT_INFO_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(LIVESET_INCREASE, (Object)liveSetIncreasePerSecond).addResult(TIME_AFTER_JVM_START, (Object)timeAfterJVMStart).build();
            }
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("IncreasingLiveSetRule_TEXT_OK")).build();
        }
        IItemCollection oldObjectItems = items.apply(ItemFilters.and((IItemFilter[])new IItemFilter[]{ItemFilters.type((String)"jdk.OldObjectSample"), ItemFilters.more((ICanonicalAccessorFactory)JfrAttributes.START_TIME, (Comparable)postWarmupTime)}));
        ReferenceTreeModel tree = ReferenceTreeModel.buildReferenceTree((IItemCollection)oldObjectItems);
        boolean anyReferrerChains = false;
        for (ReferenceTreeObject referenceTreeObject : tree.getLeakObjects()) {
            if (referenceTreeObject.getParent() == null) continue;
            anyReferrerChains = true;
            break;
        }
        if (!anyReferrerChains) {
            List calculateGroupingScore = RulesToolkit.calculateGroupingScore((IItemCollection)oldObjectItems, (IAccessorFactory)JdkAttributes.OLD_OBJECT_CLASS);
            double calculateBalanceScore = RulesToolkit.calculateBalanceScore((List)calculateGroupingScore);
            String summary = Messages.getString("IncreasingLiveSetRuleFactory_TEXT_INFO") + (calculateBalanceScore >= 25.0 ? Messages.getString("IncreasingLiveSetRule_TEXT_INFO_UNBALANCED") : Messages.getString("IncreasingLiveSetRule_TEXT_INFO_BALANCED"));
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)Math.min(calculateBalanceScore, 25.0))).setSummary(summary).setExplanation(Messages.getString("IncreasingLiveSetRule_TEXT_INFO_LONG")).addResult(LIVESET_INCREASE, (Object)liveSetIncreasePerSecond).addResult(TIME_AFTER_JVM_START, (Object)timeAfterJVMStart).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(calculateBalanceScore)).build();
        }
        List leakCandidates = tree.getLeakCandidates(((IQuantity)valueProvider.getPreferenceValue(RELEVANCE_THRESHOLD)).doubleValueIn((IUnit)UnitLookup.NUMBER_UNITY));
        if (leakCandidates.size() > 0) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("IncreasingLiveSetRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("IncreasingLiveSetRule_LEAK_CANDIDATES")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(TIME_AFTER_JVM_START, (Object)timeAfterJVMStart).addResult(LIVESET_INCREASE, (Object)liveSetIncreasePerSecond).addResult(LEAK_CANDIDATE_COUNT, (Object)UnitLookup.NUMBER_UNITY.quantity((long)leakCandidates.size())).addResult(LEAK_CANDIDATE, (Object)((ReferenceTreeObject)leakCandidates.get(0))).addResult(REFERENCE_CHAIN, this.getReferenceChain((ReferenceTreeObject)leakCandidates.get(0))).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("IncreasingLiveSetRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("IncreasingLiveSetRule_TEXT_INFO_NO_CANDIDATES")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(LIVESET_INCREASE, (Object)liveSetIncreasePerSecond).addResult(TIME_AFTER_JVM_START, (Object)timeAfterJVMStart).addResult(POST_WARMUP_TIME, (Object)postWarmupTime).build();
    }

    private List<ReferenceTreeObject> getReferenceChain(ReferenceTreeObject candidate) {
        ReferenceTreeObject chainObject = candidate.getParent();
        ArrayList<ReferenceTreeObject> referenceChain = new ArrayList<ReferenceTreeObject>();
        for (int i = 0; i < 10 && chainObject != null; chainObject = chainObject.getParent(), ++i) {
            referenceChain.add(chainObject);
        }
        return referenceChain;
    }

    private IQuantity getPostWarmupTime(IItemCollection items, IQuantity classesLoadedPercent) {
        IItemCollection classLoadItems = items.apply(JdkFilters.CLASS_LOAD_STATISTICS);
        IQuantity maxLoadedClasses = (IQuantity)classLoadItems.getAggregate(Aggregators.max((IAttribute)JdkAttributes.CLASSLOADER_LOADED_COUNT));
        if (maxLoadedClasses == null) {
            return null;
        }
        double doubleValue = classesLoadedPercent.doubleValueIn((IUnit)UnitLookup.PERCENT_UNITY);
        IQuantity loadedClassesLimit = maxLoadedClasses.multiply(doubleValue);
        return (IQuantity)classLoadItems.apply(ItemFilters.more((ICanonicalAccessorFactory)JdkAttributes.CLASSLOADER_LOADED_COUNT, (Comparable)loadedClassesLimit)).getAggregate(Aggregators.min((IAttribute)JfrAttributes.START_TIME));
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return IncreasingLiveSetRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("IncreasingLiveSetRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "memoryleak";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

