/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.ui.pages.internal;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.common.util.TypeHandling;
import org.openjdk.jmc.flightrecorder.ui.pages.internal.MethodWithFrameType;
import org.openjdk.jmc.ui.CoreImages;
import org.openjdk.jmc.ui.misc.OverlayImageDescriptor;

public class MethodWithFrameTypeLabelProvider
extends ColumnLabelProvider {
    private final Image nonoptimizedMethodImage = CoreImages.METHOD_NON_OPTIMIZED.createImage();
    private final Image defaultMethodImage = CoreImages.METHOD_DEFAULT.createImage();
    private final Image publicMethodImage = CoreImages.METHOD_PUBLIC.createImage();
    private final Image protectedMethodImage = CoreImages.METHOD_PROTECTED.createImage();
    private final Image privateMethodImage = CoreImages.METHOD_PRIVATE.createImage();
    private final Image defaultJitMethodImage = new OverlayImageDescriptor(CoreImages.METHOD_DEFAULT, false, new ImageDescriptor[]{CoreImages.METHOD_JITOVERLAY}).createImage();
    private final Image publicJitMethodImage = new OverlayImageDescriptor(CoreImages.METHOD_PUBLIC, false, new ImageDescriptor[]{CoreImages.METHOD_JITOVERLAY}).createImage();
    private final Image protectedJitMethodImage = new OverlayImageDescriptor(CoreImages.METHOD_PROTECTED, false, new ImageDescriptor[]{CoreImages.METHOD_JITOVERLAY}).createImage();
    private final Image privateJitMethodImage = new OverlayImageDescriptor(CoreImages.METHOD_PRIVATE, false, new ImageDescriptor[]{CoreImages.METHOD_JITOVERLAY}).createImage();

    public Font getFont(Object key) {
        return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    }

    public Image getImage(Object key) {
        if (key instanceof MethodWithFrameType) {
            MethodWithFrameType mwft = (MethodWithFrameType)key;
            IMCMethod method = mwft.getMethod();
            if (key instanceof IMCMethod) {
                method = (IMCMethod)key;
            } else if (key instanceof IMCFrame) {
                method = ((IMCFrame)key).getMethod();
            }
            if (method != null && method.getModifier() != null) {
                if ((method.getModifier() & 1) != 0) {
                    return mwft.getFrameType() != IMCFrame.Type.INTERPRETED ? this.publicJitMethodImage : this.publicMethodImage;
                }
                if ((method.getModifier() & 4) != 0) {
                    return mwft.getFrameType() != IMCFrame.Type.INTERPRETED ? this.protectedJitMethodImage : this.protectedMethodImage;
                }
                if ((method.getModifier() & 2) != 0) {
                    return mwft.getFrameType() != IMCFrame.Type.INTERPRETED ? this.privateJitMethodImage : this.privateMethodImage;
                }
                return mwft.getFrameType() != IMCFrame.Type.INTERPRETED ? this.defaultJitMethodImage : this.defaultMethodImage;
            }
            return this.nonoptimizedMethodImage;
        }
        return null;
    }

    public String getText(Object key) {
        if (key instanceof MethodWithFrameType) {
            MethodWithFrameType mwft = (MethodWithFrameType)key;
            key = mwft.getMethod();
        } else if (key instanceof IMCFrame) {
            key = ((IMCFrame)key).getMethod();
        }
        if (key instanceof IMCMethod) {
            return FormatToolkit.getHumanReadable((IMCMethod)((IMCMethod)key), (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
        }
        if (key instanceof IDisplayable) {
            return ((IDisplayable)key).displayUsing("exact");
        }
        return TypeHandling.getValueString((Object)key);
    }

    public String getToolTipText(Object key) {
        if (key == null) {
            return "null";
        }
        IMCMethod method = null;
        IMCFrame.Type frameType = null;
        if (key instanceof MethodWithFrameType) {
            MethodWithFrameType mwft = (MethodWithFrameType)key;
            method = mwft.getMethod();
            frameType = mwft.getFrameType();
        } else if (key instanceof IMCFrame) {
            IMCFrame frame = (IMCFrame)key;
            method = ((IMCFrame)key).getMethod();
            frameType = frame.getType();
        } else if (key instanceof IMCMethod) {
            method = (IMCMethod)key;
        }
        if (method != null) {
            return FormatToolkit.getHumanReadable((IMCMethod)method, (boolean)true, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)true) + (String)(frameType != null ? " [" + String.valueOf(frameType) + "]" : "");
        }
        if (key instanceof IDisplayable) {
            return ((IDisplayable)key).displayUsing("verbose");
        }
        return TypeHandling.getValueString((Object)key);
    }
}

