/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.stats;

public class PrimitiveArrayHandler {
    private final byte[] data;
    private final int elSize;
    private final boolean isFloatOrDouble;
    private boolean length0;
    private boolean length1;
    private boolean empty;
    private int lztOvhd = -1;
    private int unusedHighBytesOvhd = -1;

    static PrimitiveArrayHandler createInstance(byte[] data, int elSize, boolean isFloatOrDouble) {
        return new PrimitiveArrayHandler(data, elSize, isFloatOrDouble);
    }

    public boolean isLength0() {
        return this.length0;
    }

    public boolean isLength1() {
        return this.length1;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public int getLztOverhead() {
        return this.lztOvhd;
    }

    public int getUnusedHighBytesOvhd() {
        return this.unusedHighBytesOvhd;
    }

    private PrimitiveArrayHandler(byte[] data, int elSize, boolean isFloatOrDouble) {
        this.data = data;
        this.elSize = elSize;
        this.isFloatOrDouble = isFloatOrDouble;
        this.checkForProblems();
    }

    private void checkForProblems() {
        int numElements = this.data.length / this.elSize;
        if (this.data.length == 0) {
            this.length0 = true;
            return;
        }
        if (numElements == 1) {
            this.length1 = true;
        }
        switch (this.elSize) {
            case 1: {
                this.checkForElSize1();
                break;
            }
            case 2: {
                this.checkForElSize2();
                break;
            }
            case 4: {
                this.checkForElSize4();
                break;
            }
            case 8: {
                this.checkForElSize8();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported elSize: " + this.elSize);
            }
        }
    }

    private void checkForElSize1() {
        int i = this.data.length - 1;
        while (i >= 0) {
            if (this.data[i] != 0) break;
            --i;
        }
        if (i < 0) {
            this.empty = true;
        } else if (i < this.data.length / 2) {
            this.lztOvhd = this.data.length - i + 1;
        }
    }

    private void checkForElSize2() {
        int zeroElementMinIndex = this.data.length;
        boolean highByteUnusedForAll = true;
        boolean zeroTailSoFar = true;
        int i = this.data.length - 2;
        while (i >= 0) {
            int b1 = this.data[i] & 0xFF;
            int b2 = this.data[i + 1] & 0xFF;
            short value = (short)((b1 << 8) + b2);
            if (value == 0 && zeroTailSoFar) {
                zeroElementMinIndex = i;
            } else {
                zeroTailSoFar = false;
                boolean bl = highByteUnusedForAll = value >= -128 && value <= 127;
                if (!highByteUnusedForAll) break;
            }
            i -= 2;
        }
        if (zeroElementMinIndex == 0) {
            this.empty = true;
        } else {
            if (zeroElementMinIndex < this.data.length / 2) {
                this.lztOvhd = this.data.length - zeroElementMinIndex;
            }
            if (highByteUnusedForAll) {
                this.unusedHighBytesOvhd = this.data.length / 2;
            }
        }
    }

    private void checkForElSize4() {
        int zeroElementMinIndex = this.data.length;
        boolean threeBytesUnusedForAll = !this.isFloatOrDouble;
        boolean twoBytesUnusedForAll = !this.isFloatOrDouble;
        boolean zeroTailSoFar = true;
        int i = this.data.length - 4;
        while (i >= 0) {
            int b1 = this.data[i] & 0xFF;
            int b2 = this.data[i + 1] & 0xFF;
            int b3 = this.data[i + 2] & 0xFF;
            int b4 = this.data[i + 3] & 0xFF;
            int value = (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
            if (value == 0 && zeroTailSoFar) {
                zeroElementMinIndex = i;
            } else {
                zeroTailSoFar = false;
                if (!(threeBytesUnusedForAll &= value >= -128 && value <= 127) && !(twoBytesUnusedForAll &= value >= Short.MIN_VALUE && value <= Short.MAX_VALUE)) break;
            }
            i -= 4;
        }
        if (zeroElementMinIndex == 0) {
            this.empty = true;
        } else {
            if (zeroElementMinIndex < this.data.length / 2) {
                this.lztOvhd = this.data.length - zeroElementMinIndex;
            }
            if (threeBytesUnusedForAll) {
                this.unusedHighBytesOvhd = this.data.length / 4 * 3;
            } else if (twoBytesUnusedForAll) {
                this.unusedHighBytesOvhd = this.data.length / 2;
            }
        }
    }

    private void checkForElSize8() {
        int zeroElementMinIndex = this.data.length;
        boolean sevenBytesUnusedForAll = !this.isFloatOrDouble;
        boolean sixBytesUnusedForAll = !this.isFloatOrDouble;
        boolean fourBytesUnusedForAll = !this.isFloatOrDouble;
        boolean zeroTailSoFar = true;
        int i = this.data.length - 8;
        while (i >= 0) {
            long value = 0L;
            int j = i;
            while (j < i + 8) {
                value <<= 8;
                int b = this.data[j] & 0xFF;
                value |= (long)b;
                ++j;
            }
            if (value == 0L && zeroTailSoFar) {
                zeroElementMinIndex = i;
            } else {
                zeroTailSoFar = false;
                if (!(sevenBytesUnusedForAll &= value >= -128L && value <= 127L) && !(sixBytesUnusedForAll &= value >= -32768L && value <= 32767L) && !(fourBytesUnusedForAll &= value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE)) break;
            }
            i -= 8;
        }
        if (zeroElementMinIndex == 0) {
            this.empty = true;
        } else {
            if (zeroElementMinIndex < this.data.length / 2) {
                this.lztOvhd = this.data.length - zeroElementMinIndex;
            }
            if (sevenBytesUnusedForAll) {
                this.unusedHighBytesOvhd = this.data.length / 8 * 7;
            } else if (sixBytesUnusedForAll) {
                this.unusedHighBytesOvhd = this.data.length / 8 * 6;
            } else if (fourBytesUnusedForAll) {
                this.unusedHighBytesOvhd = this.data.length / 2;
            }
        }
    }
}

