/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.support;

import java.util.ArrayList;
import org.openjdk.jmc.joverflow.util.ValueWithIntId;

public class DupStringStats {
    public final int stringInstShallowSize;
    public final int nStrings;
    public final int nUniqueStringValues;
    public final int nUniqueDupStringValues;
    public final int nBackingCharArrays;
    public final ArrayList<Entry> dupStrings;
    public final long dupStringsOverhead;

    public DupStringStats(int stringInstShallowSize, int nStrings, int nUniqueStringValues, int nBackingCharArrays, ArrayList<Entry> dupStrings, long dupStringsOverhead) {
        this.stringInstShallowSize = stringInstShallowSize;
        this.nStrings = nStrings;
        this.nUniqueStringValues = nUniqueStringValues;
        this.nUniqueDupStringValues = dupStrings.size();
        this.nBackingCharArrays = nBackingCharArrays;
        this.dupStrings = dupStrings;
        this.dupStringsOverhead = dupStringsOverhead;
    }

    public static class Entry
    implements ValueWithIntId {
        public final String string;
        public final int internalId;
        public final int nStringInstances;
        public final int nBackingArrays;
        public final int maxArrayLen;
        public final int overhead;
        private int runningRemainingOvhd;
        private int runningRemainingNInstances;

        public Entry(String string, int internalId, int nStringInstances, int nBackingArrays, int maxArrayLen, int overhead) {
            this.string = string;
            this.internalId = internalId;
            this.nStringInstances = nStringInstances;
            this.nBackingArrays = nBackingArrays;
            this.maxArrayLen = maxArrayLen;
            this.overhead = overhead;
            this.runningRemainingNInstances = nStringInstances;
            this.runningRemainingOvhd = overhead;
        }

        @Override
        public int getId() {
            return this.internalId;
        }

        public int getOvhdForNextStringCopy() {
            int result = this.runningRemainingOvhd / this.runningRemainingNInstances;
            this.runningRemainingOvhd -= result;
            --this.runningRemainingNInstances;
            return result;
        }
    }
}

