/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.alert;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.openjdk.jmc.alert.AlertDialog;
import org.openjdk.jmc.alert.AlertObject;
import org.openjdk.jmc.alert.Messages;
import org.openjdk.jmc.alert.NotificationUIToolkit;
import org.openjdk.jmc.rjmx.common.IConnectionHandle;
import org.openjdk.jmc.rjmx.triggers.TriggerEvent;
import org.openjdk.jmc.rjmx.triggers.TriggerRule;
import org.openjdk.jmc.ui.MCAbstractUIPlugin;
import org.openjdk.jmc.ui.UIPlugin;
import org.openjdk.jmc.ui.misc.DisplayToolkit;
import org.osgi.framework.BundleContext;

public class AlertPlugin
extends MCAbstractUIPlugin {
    public static final String PLUGIN_ID = "org.openjdk.jmc.alert";
    public static final String IMAGE_ALERT_BANNER = "AlertBanner";
    public static final String PREF_KEY_POPUP = "POPUP";
    private static final int MAX_ALERT_SIZE = 1000;
    private static AlertPlugin plugin;
    private AlertDialog dialog;
    private final ArrayList<AlertObject> alerts = new ArrayList();

    public AlertPlugin() {
        super(PLUGIN_ID);
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault(PREF_KEY_POPUP, true);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static AlertPlugin getDefault() {
        return plugin;
    }

    public synchronized void addNotificationEvent(TriggerEvent e) {
        this.addAlertObject(new AlertObject(e.getCreationTime(), e.getSource().getServerDescriptor().getDisplayName(), e.getRule(), NotificationUIToolkit.prettyPrint(e), null));
    }

    public synchronized void addAlertObject(AlertObject ao) {
        if (this.alerts.size() >= 1000) {
            this.alerts.remove(0);
        }
        this.alerts.add(ao);
        this.showDialog(ao.getException() != null);
        this.showTrayPopup(ao);
    }

    private void showTrayPopup(AlertObject ao) {
        if (UIPlugin.getDefault().getTrayManager() != null) {
            final String message = this.createTrayMessage(ao);
            final String title = Messages.AlertPlugin_TRIGGER_ALERT_TEXT;
            DisplayToolkit.safeAsyncExec((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    UIPlugin.getDefault().getTrayManager().showTooltip(title, message, 4104);
                }
            });
        }
    }

    public String createTrayMessage(AlertObject ae) {
        if (ae.getException() == null) {
            return this.createRuleMessage(ae);
        }
        return ae.getMessage();
    }

    private String createExceptionMessage(Date d, Throwable exception, TriggerRule rule, String triggerMessage) {
        StringBuilder builder = new StringBuilder();
        if (d != null) {
            DateFormat df1 = DateFormat.getDateInstance(3);
            DateFormat df2 = DateFormat.getTimeInstance(2);
            builder.append(MessageFormat.format(Messages.AlertPlugin_TIME_X_Y_TEXT, df1.format(d), df2.format(d)));
        }
        builder.append(NLS.bind((String)Messages.AlertPlugin_MESSAGE_EXCEPTION_INVOKING_ACTION, (Object)rule.getName()));
        if (triggerMessage != null) {
            builder.append("\n" + triggerMessage + "\n");
        }
        builder.append(NLS.bind((String)Messages.AlertPlugin_MESSAGE_EXCEPTION_INVOKING_ACTION_MESSAGE_CAPTION, (Object)exception.getLocalizedMessage()));
        builder.append(Messages.AlertPlugin_MESSAGE_EXCEPTION_INVOKING_ACTION_MESSAGE_MORE_INFORMATION);
        return builder.toString();
    }

    private String createRuleMessage(AlertObject ae) {
        Date d = ae.getCreationTime();
        Object message = MessageFormat.format(Messages.AlertPlugin_RULE_X_Y_TEXT, ae.getRule().getRulePath(), ae.getRule().getName());
        if (d != null) {
            DateFormat df1 = DateFormat.getDateInstance(3);
            DateFormat df2 = DateFormat.getTimeInstance(2);
            message = (String)message + MessageFormat.format(Messages.AlertPlugin_TIME_X_Y_TEXT, df1.format(d), df2.format(d));
        }
        message = (String)message + MessageFormat.format(Messages.AlertPlugin_SOURCE_X_TEXT, ae.getSourceName());
        return message;
    }

    public void setPopup(boolean popup) {
        this.getPreferenceStore().setValue(PREF_KEY_POPUP, popup);
    }

    public boolean getPopup() {
        return this.getPreferenceStore().getBoolean(PREF_KEY_POPUP);
    }

    public void showDialog(boolean alwaysShow) {
        if (this.getPopup() || alwaysShow || this.hasDialog()) {
            DisplayToolkit.safeAsyncExec((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    if (shell != null && !shell.isDisposed()) {
                        if (!AlertPlugin.this.hasDialog()) {
                            AlertPlugin.this.dialog = AlertPlugin.createDialog(shell);
                        }
                        if (AlertPlugin.this.dialog != null) {
                            AlertPlugin.this.dialog.open();
                            AlertPlugin.this.dialog.refreshAlertDialog();
                        }
                    }
                }
            });
        }
    }

    public boolean hasDialog() {
        if (this.dialog == null) {
            return false;
        }
        if (this.dialog.getShell() == null) {
            return false;
        }
        return !this.dialog.getShell().isDisposed();
    }

    public static AlertDialog createDialog(Shell shell) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            return new AlertDialog(shell);
        }
        return null;
    }

    public synchronized void clearNotificationEventLog() {
        this.alerts.clear();
    }

    public synchronized AlertObject[] getAlerts() {
        return this.alerts.toArray(new AlertObject[this.alerts.size()]);
    }

    public Image getImage(String image) {
        return this.getImageRegistry().get(image);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(IMAGE_ALERT_BANNER, this.getImageDescriptor("icons/trigger-alerts-wiz.gif").createImage());
    }

    public synchronized void addException(IConnectionHandle connectionHandle, TriggerRule rule, Throwable throwable, String triggerMessage) {
        Date creationDate = new Date();
        this.addAlertObject(new AlertObject(creationDate, connectionHandle.getServerDescriptor().getDisplayName(), rule, this.createExceptionMessage(creationDate, throwable, rule, triggerMessage), throwable));
    }
}

