/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.internal;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.openjdk.jmc.rjmx.RJMXPlugin;

public class ProtocolInitializer {
    private static final String EXTENSION_POINT = "org.openjdk.jmc.rjmx.jmxProtocols";
    private static final String EXTENSION_ELEMENT_CLIENT = "client";
    private static final String EXTENSION_ATTRIBUTE_CLASS = "class";
    private static final String EXTENSION_ATTRIBUTE_PROTOCOL = "protocol";
    private static final String ATTRIBUTE_KEY = "name";
    private static final String TAG_SYSPROPERTY = "sysproperty";
    private static final String ATTRIBUTE_INCLUDE = "include";
    private static final String ATTRIBUTE_SEPARATOR = "separator";

    public JMXConnector newJMXConnector(JMXServiceURL serviceURL, Map<String, ?> environment) throws IOException {
        JMXConnectorProvider realProvider = this.findProtocolExtension(serviceURL);
        if (realProvider == null) {
            return null;
        }
        return realProvider.newJMXConnector(serviceURL, environment);
    }

    public JMXConnectorProvider findProtocolExtension(JMXServiceURL serviceURL) {
        try {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(EXTENSION_POINT);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                if (config.getName().equals(EXTENSION_ELEMENT_CLIENT)) {
                    String protocol = config.getAttribute(EXTENSION_ATTRIBUTE_PROTOCOL);
                    if (serviceURL.getProtocol().equals(protocol)) {
                        JMXConnectorProvider provider = (JMXConnectorProvider)config.createExecutableExtension(EXTENSION_ATTRIBUTE_CLASS);
                        IConfigurationElement[] iConfigurationElementArray2 = config.getChildren(TAG_SYSPROPERTY);
                        int n3 = iConfigurationElementArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement prop = iConfigurationElementArray2[n4];
                            ProtocolInitializer.ensureSystemProperty(prop.getAttribute(ATTRIBUTE_KEY), prop.getAttribute(ATTRIBUTE_INCLUDE), prop.getAttribute(ATTRIBUTE_SEPARATOR));
                            ++n4;
                        }
                        return provider;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not instantiate JMX protocol provider!", e);
        }
        return null;
    }

    private static void ensureSystemProperty(String key, String include, String separator) {
        String org = System.getProperty(key);
        if (org == null) {
            System.setProperty(key, include);
            return;
        }
        if ((separator + org + separator).indexOf(separator + include + separator) < 0) {
            System.setProperty(key, org + separator + include);
        }
    }
}

