/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.agent.manager.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openjdk.jmc.console.agent.AgentPlugin;
import org.openjdk.jmc.console.agent.manager.model.Event;
import org.openjdk.jmc.console.agent.manager.model.IEvent;
import org.openjdk.jmc.console.agent.manager.model.IPreset;
import org.openjdk.jmc.console.agent.manager.model.IPresetStorageDelegate;
import org.openjdk.jmc.console.agent.manager.model.PresetRepository;
import org.openjdk.jmc.console.agent.messages.internal.Messages;
import org.openjdk.jmc.console.agent.utils.ProbeValidator;
import org.openjdk.jmc.console.agent.utils.ValidationResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Preset
implements IPreset {
    private static final String FILE_NAME_EXTENSION = ".xml";
    private static final String DEFAULT_FILE_NAME = "new_file.xml";
    private static final String DEFAULT_CLASS_PREFIX = "__JFREvent";
    private static final boolean DEFAULT_BOOLEAN_FIELD = false;
    private static final String XML_TAG_JFR_AGENT = "jfragent";
    private static final String XML_TAG_CONFIG = "config";
    private static final String XML_TAG_CLASS_PREFIX = "classprefix";
    private static final String XML_TAG_ALLOW_TO_STRING = "allowtostring";
    private static final String XML_TAG_ALLOW_CONVERTER = "allowconverter";
    private static final String XML_TAG_EVENTS = "events";
    private static final String XML_TAG_EVENT = "event";
    private static final Pattern ID_WITH_COUNT_PATTERN = Pattern.compile("^(.*)\\.(\\d+)$");
    private static final Pattern ID_COUNT_SUFFIX_PATTERN = Pattern.compile("^\\.(\\d+)$");
    private static final Pattern NAME_WITH_COUNT_PATTERN = Pattern.compile("^(.*)\\s*\\((\\d+)\\)$");
    private static final Pattern NAME_COUNT_SUFFIX_PATTERN = Pattern.compile("^\\s*\\((\\d+)\\)$");
    private static final String XML_PARSER_DISALLOW_DOCTYPE_ATTRIBUTE = "http://apache.org/xml/features/disallow-doctype-decl";
    private final PresetRepository presetRepository;
    private IPresetStorageDelegate storageDelegate;
    private final List<IEvent> events = new ArrayList<IEvent>();
    private String fileName;
    private String classPrefix;
    private boolean allowToString;
    private boolean allowConverter;

    Preset(PresetRepository repository) {
        this.presetRepository = repository;
        this.fileName = DEFAULT_FILE_NAME;
        this.classPrefix = DEFAULT_CLASS_PREFIX;
        this.allowToString = false;
        this.allowConverter = false;
    }

    Preset(PresetRepository repository, IPresetStorageDelegate storageDelegate) throws IOException, SAXException {
        this(repository);
        if (storageDelegate != null) {
            this.deserialize(storageDelegate.getContents());
            this.fileName = storageDelegate.getName();
        }
    }

    @Override
    public void deserialize(InputStream xmlStream) throws IOException, SAXException {
        byte[] output = new byte[]{};
        int length = Integer.MAX_VALUE;
        int pos = 0;
        while (pos < length) {
            int cc;
            int bytesToRead;
            if (pos >= output.length) {
                bytesToRead = Math.min(length - pos, output.length + 1024);
                if (output.length < pos + bytesToRead) {
                    output = Arrays.copyOf(output, pos + bytesToRead);
                }
            } else {
                bytesToRead = output.length - pos;
            }
            if ((cc = xmlStream.read(output, pos, bytesToRead)) < 0) {
                if (output.length == pos) break;
                output = Arrays.copyOf(output, pos);
                break;
            }
            pos += cc;
        }
        this.deserialize(new String(output, StandardCharsets.UTF_8));
    }

    @Override
    public void deserialize(String xmlSource) throws IOException, SAXException {
        DocumentBuilder builder;
        ProbeValidator validator = new ProbeValidator();
        validator.validate(new StreamSource(new ByteArrayInputStream(xmlSource.getBytes(StandardCharsets.UTF_8))));
        ValidationResult result = validator.getValidationResult();
        if (!result.isValid()) {
            if (result.getFatalError() != null) {
                throw result.getFatalError();
            }
            throw result.getErrors().get(0);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature(XML_PARSER_DISALLOW_DOCTYPE_ATTRIBUTE, true);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            factory.setValidating(true);
            builder = factory.newDocumentBuilder();
            builder.setErrorHandler(null);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document document = builder.parse(new ByteArrayInputStream(xmlSource.getBytes(StandardCharsets.UTF_8)));
        NodeList elements = document.getElementsByTagName(XML_TAG_CONFIG);
        if (elements.getLength() != 0) {
            Element configElement = (Element)elements.item(0);
            if ((elements = configElement.getElementsByTagName(XML_TAG_CLASS_PREFIX)).getLength() != 0) {
                this.classPrefix = elements.item(0).getTextContent();
            }
            if ((elements = configElement.getElementsByTagName(XML_TAG_ALLOW_TO_STRING)).getLength() != 0) {
                this.allowToString = Boolean.parseBoolean(elements.item(0).getTextContent());
            }
            if ((elements = configElement.getElementsByTagName(XML_TAG_ALLOW_CONVERTER)).getLength() != 0) {
                this.allowConverter = Boolean.parseBoolean(elements.item(0).getTextContent());
            }
        }
        if ((elements = document.getElementsByTagName(XML_TAG_EVENTS)).getLength() != 0) {
            Element eventsElement = (Element)elements.item(0);
            elements = eventsElement.getElementsByTagName(XML_TAG_EVENT);
            int i = 0;
            while (i < elements.getLength()) {
                this.events.add(this.createEvent((Element)elements.item(i)));
                ++i;
            }
        }
    }

    private Element buildConfigElement(Document document) {
        Element element = document.createElement(XML_TAG_CONFIG);
        Element classPrefixElement = document.createElement(XML_TAG_CLASS_PREFIX);
        classPrefixElement.setTextContent(this.classPrefix != null ? this.classPrefix : "");
        element.appendChild(classPrefixElement);
        Element allowToStringElement = document.createElement(XML_TAG_ALLOW_TO_STRING);
        allowToStringElement.setTextContent(String.valueOf(this.allowToString));
        element.appendChild(allowToStringElement);
        Element allowConverterElement = document.createElement(XML_TAG_ALLOW_CONVERTER);
        allowConverterElement.setTextContent(String.valueOf(this.allowConverter));
        element.appendChild(allowConverterElement);
        return element;
    }

    @Override
    public Document buildDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature(XML_PARSER_DISALLOW_DOCTYPE_ATTRIBUTE, true);
            factory.setXIncludeAware(false);
            factory.setExpandEntityReferences(false);
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document document = builder.newDocument();
        Element jfrAgentElement = document.createElement(XML_TAG_JFR_AGENT);
        document.appendChild(jfrAgentElement);
        jfrAgentElement.appendChild(this.buildConfigElement(document));
        Element eventsElement = document.createElement(XML_TAG_EVENTS);
        for (IEvent event : this.events) {
            eventsElement.appendChild(event.buildElement(document));
        }
        jfrAgentElement.appendChild(eventsElement);
        return document;
    }

    @Override
    public String serialize() {
        Transformer transformer;
        Document document = this.buildDocument();
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            tf.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            tf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformer = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "yes");
        StringWriter writer = new StringWriter(2000);
        try {
            transformer.transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return writer.getBuffer().toString();
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException(Messages.Preset_ERROR_FILE_NAME_CANNOT_BE_EMPTY_OR_NULL);
        }
        this.fileName = fileName;
    }

    @Override
    public void setClassPrefix(String prefix) {
        if (prefix != null) {
            prefix = prefix.trim();
        }
        this.classPrefix = prefix;
    }

    @Override
    public String getClassPrefix() {
        return this.classPrefix;
    }

    @Override
    public void setAllowToString(boolean allowed) {
        this.allowToString = allowed;
    }

    @Override
    public boolean getAllowToString() {
        return this.allowToString;
    }

    @Override
    public void setAllowConverter(boolean allowed) {
        this.allowConverter = allowed;
    }

    @Override
    public boolean getAllowConverter() {
        return this.allowConverter;
    }

    @Override
    public IEvent[] getEvents() {
        return this.events.toArray(new IEvent[0]);
    }

    @Override
    public void addEvent(IEvent event) {
        if (this.containsId(event.getId())) {
            throw new IllegalArgumentException(Messages.Preset_ERROR_MUST_HAVE_UNIQUE_ID);
        }
        if (this.containsEventClassName(event)) {
            throw new IllegalArgumentException(Messages.Preset_ERROR_MUST_HAVE_UNIQUE_EVENT_CLASS_NAME);
        }
        this.events.add(event);
    }

    @Override
    public void removeEvent(IEvent event) {
        this.events.remove(event);
    }

    @Override
    public boolean containsEvent(IEvent event) {
        return this.events.contains(event);
    }

    @Override
    public IEvent createEvent() {
        Event event = new Event(this);
        String idPrefix = this.fileName;
        if (idPrefix.endsWith(FILE_NAME_EXTENSION)) {
            idPrefix = idPrefix.substring(0, idPrefix.lastIndexOf(FILE_NAME_EXTENSION)).replaceAll("\\s", "_");
        }
        idPrefix = this.nextUniqueEventId(idPrefix + ".event.1");
        String name = this.nextUniqueEventName(event.getName());
        event.setId(idPrefix);
        event.setName(name);
        return event;
    }

    private IEvent createEvent(Element element) {
        return new Event(this, element);
    }

    @Override
    public void updateEvent(IEvent original, IEvent workingCopy) {
        if (this.events.remove(original)) {
            this.events.add(workingCopy);
        }
    }

    @Override
    public Preset createWorkingCopy() {
        Preset copy = new Preset(this.presetRepository);
        copy.fileName = this.fileName;
        copy.classPrefix = this.classPrefix;
        copy.allowToString = this.allowToString;
        copy.allowConverter = this.allowConverter;
        copy.events.addAll(this.events.stream().map(IEvent::createWorkingCopy).collect(Collectors.toList()));
        return copy;
    }

    @Override
    public Preset createDuplicate() {
        Preset duplicate = this.createWorkingCopy();
        duplicate.fileName = this.presetRepository.nextUniqueName(duplicate.fileName);
        return duplicate;
    }

    @Override
    public String nextUniqueEventName(String originalName) {
        String baseName = originalName = originalName.trim();
        long proposedCount = -1L;
        Matcher matcher = NAME_WITH_COUNT_PATTERN.matcher(originalName);
        if (matcher.matches()) {
            try {
                long count = Long.parseLong(matcher.group(2));
                baseName = matcher.group(1).trim();
                proposedCount = count;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int baseLen = baseName.length();
        for (IEvent event : this.events) {
            String tempName = event.getName().trim();
            if (!tempName.startsWith(baseName)) continue;
            if (tempName.equals(baseName) && proposedCount < 1L) {
                proposedCount = 1L;
                continue;
            }
            Matcher tempMatch = NAME_COUNT_SUFFIX_PATTERN.matcher(tempName.substring(baseLen));
            if (!tempMatch.matches()) continue;
            try {
                long count = Long.parseLong(tempMatch.group(1));
                if (count >= Long.MAX_VALUE) continue;
                proposedCount = Math.max(proposedCount, count + 1L);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (proposedCount == -1L) {
            return baseName;
        }
        return baseName + " (" + proposedCount + ")";
    }

    @Override
    public String nextUniqueEventId(String originalName) {
        String baseName = originalName = originalName.trim();
        long proposedCount = -1L;
        Matcher matcher = ID_WITH_COUNT_PATTERN.matcher(originalName);
        if (matcher.matches()) {
            try {
                long count = Long.parseLong(matcher.group(2));
                baseName = matcher.group(1).trim();
                proposedCount = count;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int baseLen = baseName.length();
        for (IEvent event : this.events) {
            String tempName = event.getId().trim();
            if (!tempName.startsWith(baseName)) continue;
            if (tempName.equals(baseName) && proposedCount < 1L) {
                proposedCount = 1L;
                continue;
            }
            Matcher tempMatch = ID_COUNT_SUFFIX_PATTERN.matcher(tempName.substring(baseLen));
            if (!tempMatch.matches()) continue;
            try {
                long count = Long.parseLong(tempMatch.group(1));
                if (count >= Long.MAX_VALUE) continue;
                proposedCount = Math.max(proposedCount, count + 1L);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (proposedCount == -1L) {
            return baseName;
        }
        return baseName + "." + proposedCount;
    }

    @Override
    public void setStorageDelegate(IPresetStorageDelegate storageDelegate) {
        this.storageDelegate = storageDelegate;
    }

    @Override
    public IPresetStorageDelegate getStorageDelegate() {
        return this.storageDelegate;
    }

    @Override
    public boolean save() {
        if (this.storageDelegate == null) {
            return false;
        }
        try {
            return this.storageDelegate.save(this.fileName, this.serialize());
        }
        catch (IOException e) {
            AgentPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to save preset", e);
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean delete() {
        if (this.storageDelegate == null) {
            return true;
        }
        return this.storageDelegate.delete();
    }

    private boolean containsId(String id) {
        for (IEvent e : this.events) {
            if (!e.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    private boolean containsEventClassName(IEvent event) {
        for (IEvent e : this.events) {
            if (!e.getClazz().equals(event.getClazz()) || !e.getName().equals(event.getName())) continue;
            return true;
        }
        return false;
    }
}

