/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.providers;

import java.awt.Polygon;
import java.util.Iterator;
import org.openjdk.jmc.common.xydata.DataSeries;
import org.openjdk.jmc.greychart.YAxis;
import org.openjdk.jmc.greychart.impl.LongWorldToDeviceConverter;
import org.openjdk.jmc.greychart.impl.OptimizingProvider;
import org.openjdk.jmc.greychart.impl.SamplePoint;
import org.openjdk.jmc.greychart.impl.WorldToDeviceConverter;

public class CompositeOptimizingProvider
implements OptimizingProvider {
    private final OptimizingProvider[] providers;

    public CompositeOptimizingProvider(OptimizingProvider[] providers) {
        this.providers = providers;
    }

    @Override
    public void setDataChanged(boolean changed) {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.setDataChanged(changed);
            ++n2;
        }
    }

    @Override
    public boolean hasDataChanged() {
        return false;
    }

    @Override
    public Iterator<SamplePoint> getSamples(int width) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Polygon getSamplesPolygon(LongWorldToDeviceConverter xWorldToDevice, WorldToDeviceConverter yWorldToDevice) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setResolution(int resolution) {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.setResolution(resolution);
            ++n2;
        }
    }

    @Override
    public boolean update() {
        boolean update = false;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            if (provider.update()) {
                update = true;
            }
            ++n2;
        }
        return update;
    }

    @Override
    public OptimizingProvider[] getChildren() {
        return this.providers;
    }

    @Override
    public DataSeries getDataSeries() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMaxX() {
        long max = Long.MIN_VALUE;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            long maxX = provider.getMaxX();
            if (!Double.isNaN(maxX)) {
                max = Math.max(maxX, max);
            }
            ++n2;
        }
        return max;
    }

    @Override
    public double getMaxY() {
        double max = Double.NEGATIVE_INFINITY;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            double maxY = provider.getMaxY();
            if (!Double.isNaN(maxY)) {
                max = Math.max(maxY, max);
            }
            ++n2;
        }
        return max;
    }

    @Override
    public double getMinY() {
        double min = Double.POSITIVE_INFINITY;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            double minY = provider.getMinY();
            if (!Double.isNaN(minY)) {
                min = Math.min(minY, min);
            }
            ++n2;
        }
        return min;
    }

    @Override
    public WorldToDeviceConverter getYSampleToDeviceConverterFor(YAxis yAxis) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getMinX() {
        long min = Long.MAX_VALUE;
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            long minX = provider.getMinX();
            if (!Double.isNaN(minX)) {
                min = Math.min(minX, min);
            }
            ++n2;
        }
        return min;
    }

    @Override
    public void setRange(long start, long end) {
        OptimizingProvider[] optimizingProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            OptimizingProvider provider = optimizingProviderArray[n2];
            provider.setRange(start, end);
            ++n2;
        }
    }

    public void setIntegrate(boolean integrate) {
    }
}

