/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.console.ui.tabs.threads;

import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.openjdk.jmc.console.ui.ConsolePlugin;
import org.openjdk.jmc.console.ui.messages.internal.Messages;
import org.openjdk.jmc.console.ui.tabs.threads.IThreadsModel;
import org.openjdk.jmc.console.ui.tabs.threads.ThreadInfoCompositeSupport;
import org.openjdk.jmc.console.ui.tabs.threads.ThreadModelException;

public class StackTraceContentProvider
implements ITreeContentProvider {
    private final IThreadsModel m_threadsModel;

    public StackTraceContentProvider(IThreadsModel threadsModel) {
        this.m_threadsModel = threadsModel;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IStructuredSelection) {
            long[] threadIDArray = StackTraceContentProvider.extractThreadIDsFromSelection((IStructuredSelection)inputElement);
            try {
                return this.m_threadsModel.getThreadInfo(threadIDArray, Integer.MAX_VALUE);
            }
            catch (ThreadModelException e) {
                ConsolePlugin.getDefault().getLogger().log(Level.WARNING, Messages.ThreadsModel_EXCEPTION_NO_THREAD_INFO_MESSAGE, e);
            }
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ThreadInfoCompositeSupport) {
            return ((ThreadInfoCompositeSupport)parentElement).getStackTrace();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public static long[] extractThreadIDsFromSelection(IStructuredSelection selection) {
        ArrayList<Long> threadIDs = new ArrayList<Long>();
        for (ThreadInfoCompositeSupport tics : selection) {
            Long id = tics.getThreadId();
            if (id == null) continue;
            threadIDs.add(id);
        }
        long[] threadIDArray = new long[threadIDs.size()];
        int n = 0;
        while (n < threadIDArray.length) {
            threadIDArray[n] = (Long)threadIDs.get(n);
            ++n;
        }
        return threadIDArray;
    }
}

