/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;

public enum CollectorType {
    CMS("ConcurrentMarkSweep"),
    DEF_NEW("DefNew"),
    G1_FULL("G1Full"),
    G1_NEW("G1New"),
    G1_OLD("G1Old"),
    PAR_NEW("ParNew"),
    PARALLEL_OLD("ParallelOld"),
    PARALLEL_SCAVENGE("ParallelScavenge"),
    PS_MARK_SWEEP("PSMarkSweep"),
    SERIAL_OLD("SerialOld"),
    Z("Z"),
    NA("N/A"),
    UNKNOWN("");

    private final String collectorName;

    private CollectorType(String collectorName) {
        this.collectorName = collectorName;
    }

    public String getCollectorName() {
        return this.collectorName;
    }

    public static CollectorType getOldCollectorType(IItemCollection items) {
        String oc = (String)items.getAggregate(JdkAggregators.OLD_COLLECTOR);
        if (oc != null) {
            for (CollectorType collectorType : CollectorType.values()) {
                if (!collectorType.getCollectorName().equals(oc)) continue;
                return collectorType;
            }
        }
        return UNKNOWN;
    }
}

