/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.joverflow.ui.swt;

import java.util.HashSet;
import java.util.function.Predicate;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.openjdk.jmc.joverflow.ui.swt.ColumnLayout;
import org.openjdk.jmc.joverflow.ui.util.FilterChangedListener;

public class FilterList<T>
extends Composite {
    private final ScrolledComposite mScrolledComposite;
    private final Composite mFilterContainer;
    private final HashSet<Predicate<T>> mFilters = new HashSet();
    private final ListenerList<FilterChangedListener> mListeners = new ListenerList();

    public FilterList(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.mScrolledComposite = new ScrolledComposite((Composite)this, 2560);
        this.mFilterContainer = new Composite((Composite)this.mScrolledComposite, 0);
        this.mFilterContainer.setLayout((Layout)new ColumnLayout());
        this.mScrolledComposite.setContent((Control)this.mFilterContainer);
        this.mScrolledComposite.setExpandVertical(true);
        this.mScrolledComposite.setExpandHorizontal(true);
    }

    public boolean addFilter(final Predicate<T> filter) {
        if (!this.mFilters.add(filter)) {
            return false;
        }
        final Button button = new Button(this.mFilterContainer, 0);
        button.setText(filter.toString());
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FilterList.this.mFilters.remove(filter);
                button.dispose();
                FilterList.this.layout(true, true);
                Rectangle r = FilterList.this.mScrolledComposite.getClientArea();
                FilterList.this.mScrolledComposite.setMinSize(FilterList.this.mFilterContainer.computeSize(r.width, -1));
                FilterList.this.notifyFilterChangedListeners();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.layout(true, true);
        Rectangle r = this.mScrolledComposite.getClientArea();
        this.mScrolledComposite.setMinSize(this.mFilterContainer.computeSize(r.width, -1));
        this.notifyFilterChangedListeners();
        return true;
    }

    public boolean filter(T target) {
        Predicate<Object> res = in -> true;
        for (Predicate<T> filter : this.mFilters) {
            res = res.and(filter);
        }
        return res.test(target);
    }

    public void reset() {
        this.mFilters.clear();
        Control[] controlArray = this.mFilterContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control filter = controlArray[n2];
            filter.dispose();
            ++n2;
        }
        this.notifyFilterChangedListeners();
    }

    public void addFilterChangedListener(FilterChangedListener listener) {
        this.mListeners.add((Object)listener);
    }

    public void removeFilterChangedListener(FilterChangedListener listener) {
        this.mListeners.remove((Object)listener);
    }

    private void notifyFilterChangedListeners() {
        for (FilterChangedListener l : this.mListeners) {
            l.onFilterChanged();
        }
    }
}

