/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.actionprovider.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.openjdk.jmc.common.action.Executable;
import org.openjdk.jmc.common.action.IUserAction;
import org.openjdk.jmc.common.resource.Resource;
import org.openjdk.jmc.rjmx.IServerHandle;
import org.openjdk.jmc.rjmx.actionprovider.IActionFactory;
import org.openjdk.jmc.ui.common.resource.IImageResource;
import org.openjdk.jmc.ui.common.util.AdapterUtil;

public class ActionDescriptor
implements IUserAction,
IAdaptable,
IImageResource {
    private final IConfigurationElement element;
    private final IServerHandle jvm;
    private Executable executable;
    private final Resource imageResource;

    public ActionDescriptor(IConfigurationElement element, IServerHandle jvm) {
        this.element = element;
        this.jvm = jvm;
        this.imageResource = new Resource(element.getDeclaringExtension().getContributor().getName(), element.getAttribute("icon"));
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public String getName() {
        return this.element.getAttribute("label");
    }

    public String toString() {
        try {
            return "   Action= " + this.getName();
        }
        catch (Exception e) {
            return "   Action= " + this.getName() + " " + String.valueOf(e);
        }
    }

    private synchronized Executable getExecutable() throws CoreException {
        if (this.executable == null) {
            this.executable = ((IActionFactory)this.element.createExecutableExtension("factory")).createAction(this.jvm);
        }
        return this.executable;
    }

    public void execute() throws Exception {
        this.getExecutable().execute();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IImageResource.class) {
            return this;
        }
        try {
            return AdapterUtil.getAdapter((Object)this.getExecutable(), (Class)adapter);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public Resource getImageResource() {
        return this.imageResource;
    }
}

