/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.rjmx.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.openjdk.jmc.rjmx.IPropertySyntheticAttribute;
import org.openjdk.jmc.rjmx.RJMXPlugin;
import org.openjdk.jmc.rjmx.common.ISyntheticAttribute;
import org.openjdk.jmc.rjmx.common.ISyntheticNotification;
import org.openjdk.jmc.rjmx.common.internal.SyntheticAttributeEntry;
import org.openjdk.jmc.rjmx.common.internal.SyntheticNotificationEntry;
import org.openjdk.jmc.rjmx.common.subscription.MRI;

public class SyntheticRepositoryInitializer {
    public static List<SyntheticAttributeEntry> initializeAttributeEntries() {
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint("org.openjdk.jmc.rjmx.syntheticattribute");
        IExtension[] extensions = ep.getExtensions();
        ArrayList<SyntheticAttributeEntry> attributeCandidates = new ArrayList<SyntheticAttributeEntry>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                if (config.getName().equals("syntheticAttribute")) {
                    try {
                        ISyntheticAttribute attribute = (ISyntheticAttribute)config.createExecutableExtension("class");
                        SyntheticAttributeEntry candidate = SyntheticRepositoryInitializer.createAttributeEntry(attribute, config);
                        attributeCandidates.add(candidate);
                    }
                    catch (CoreException e) {
                        RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not instantiate synthetic attribute!", e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return attributeCandidates;
    }

    private static SyntheticAttributeEntry createAttributeEntry(ISyntheticAttribute attribute, IConfigurationElement config) {
        String attributeName = config.getAttribute("attributeName");
        String description = config.getAttribute("description");
        String type = config.getAttribute("type");
        boolean readable = Boolean.valueOf(config.getAttribute("readable"));
        boolean writeable = Boolean.valueOf(config.getAttribute("writeable"));
        boolean isIs = Boolean.valueOf(config.getAttribute("isIs"));
        if (attribute instanceof IPropertySyntheticAttribute) {
            Map<String, Object> properties = SyntheticRepositoryInitializer.parseProperties(config.getChildren("properties"));
            ((IPropertySyntheticAttribute)attribute).setProperties(properties);
        }
        MRI descriptor = MRI.createFromQualifiedName((String)attributeName);
        return new SyntheticAttributeEntry(attribute, descriptor, description, type, readable, writeable, isIs);
    }

    private static Map<String, Object> parseProperties(IConfigurationElement[] children) {
        if (children == null || children.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        IConfigurationElement[] iConfigurationElementArray = children[0].getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            SyntheticRepositoryInitializer.parseProperty(child, properties);
            ++n2;
        }
        return properties;
    }

    private static void parseProperty(IConfigurationElement child, Map<String, Object> properties) {
        String key = child.getAttribute("key");
        try {
            if ("string".equals(child.getName())) {
                properties.put(key, child.getAttribute("value"));
            } else if ("boolean".equals(child.getName())) {
                properties.put(key, Boolean.valueOf(child.getAttribute("value")));
            } else if ("integer".equals(child.getName())) {
                properties.put(key, Integer.parseInt(child.getAttribute("value")));
            } else if ("float".equals(child.getName())) {
                properties.put(key, Float.valueOf(Float.parseFloat(child.getAttribute("value"))));
            }
        }
        catch (NumberFormatException e) {
            properties.put(key, e.getMessage());
        }
    }

    public static List<SyntheticNotificationEntry> initializeNotificationEntries() {
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint("org.openjdk.jmc.rjmx.syntheticnotification");
        IExtension[] extensions = ep.getExtensions();
        ArrayList<SyntheticNotificationEntry> notificationCandidates = new ArrayList<SyntheticNotificationEntry>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                SyntheticNotificationEntry candidate;
                IConfigurationElement config = iConfigurationElementArray[n4];
                if (config.getName().equals("syntheticNotification") && (candidate = SyntheticRepositoryInitializer.createNotificationEntry(config)) != null) {
                    notificationCandidates.add(candidate);
                }
                ++n4;
            }
            ++n2;
        }
        return notificationCandidates;
    }

    private static SyntheticNotificationEntry createNotificationEntry(IConfigurationElement config) {
        String notificationName = config.getAttribute("notificationName");
        try {
            ISyntheticNotification notification = (ISyntheticNotification)config.createExecutableExtension("class");
            String description = config.getAttribute("description");
            String type = config.getAttribute("type");
            String message = config.getAttribute("message");
            MRI descriptor = MRI.createFromQualifiedName((String)notificationName);
            return new SyntheticNotificationEntry(notification, descriptor, description, type, message);
        }
        catch (CoreException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not create synthetic notification for " + notificationName, e);
            return null;
        }
    }
}

