/*
 * Decompiled with CFR 0.152.
 */
package io.github.bric3.fireplace.flamegraph.animation;

import io.github.bric3.fireplace.flamegraph.FlamegraphView;
import io.github.bric3.fireplace.flamegraph.ZoomTarget;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.pushingpixels.radiance.animation.api.Timeline;
import org.pushingpixels.radiance.animation.api.callback.TimelineCallback;
import org.pushingpixels.radiance.animation.api.ease.Sine;
import org.pushingpixels.radiance.animation.api.ease.TimelineEase;
import org.pushingpixels.radiance.animation.api.swing.EventDispatchThreadTimelineCallbackAdapter;

public class ZoomAnimation
implements FlamegraphView.ZoomAction {
    private static final long ZOOM_ANIMATION_DURATION = 400L;
    private static final String ZOOM_ANIMATION_DISABLED_KEY = "fireplace.zoom.animation.disabled";
    private boolean animateZoomTransitions = !Boolean.getBoolean("fireplace.zoom.animation.disabled");

    public <T> void install(FlamegraphView<T> flameGraph) {
        flameGraph.overrideZoomAction((FlamegraphView.ZoomAction)this);
    }

    public boolean isAnimateZoomTransitions() {
        return this.animateZoomTransitions;
    }

    public void setAnimateZoomTransitions(boolean animateZoomTransitions) {
        this.animateZoomTransitions = animateZoomTransitions;
    }

    public <T> boolean zoom(final @NotNull FlamegraphView.ZoomableComponent<T> zoomableComponent, final @NotNull ZoomTarget<T> zoomTarget) {
        System.getLogger(zoomableComponent.getClass().getName()).log(System.Logger.Level.DEBUG, () -> "zoom to " + zoomTarget);
        if (!this.isAnimateZoomTransitions()) {
            return false;
        }
        final int startW = zoomableComponent.getWidth();
        final int startH = zoomableComponent.getHeight();
        final double deltaW = zoomTarget.getWidth() - (double)startW;
        final double deltaH = zoomTarget.getHeight() - (double)startH;
        Point location = zoomableComponent.getLocation();
        final int startX = location.x;
        final int startY = location.y;
        final double deltaX = zoomTarget.getX() - (double)startX;
        final double deltaY = zoomTarget.getY() - (double)startY;
        ((Timeline.Builder)((Timeline.Builder)((Timeline.Builder)Timeline.builder().setDuration(400L)).setEase((TimelineEase)new Sine())).addCallback((TimelineCallback)new EventDispatchThreadTimelineCallbackAdapter(){

            public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
                if (newState.equals((Object)Timeline.TimelineState.DONE)) {
                    zoomableComponent.zoom(zoomTarget);
                }
            }

            public void onTimelinePulse(float durationFraction, float timelinePosition) {
                zoomableComponent.zoom(new ZoomTarget(startX + (int)((double)timelinePosition * deltaX), startY + (int)((double)timelinePosition * deltaY), (int)((double)startW + (double)timelinePosition * deltaW), (int)((double)startH + (double)timelinePosition * deltaH), zoomTarget.targetFrame));
            }
        })).build().playSkipping(3L);
        return true;
    }
}

