/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.IRecordingSetting;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;

public class ResultBuilder {
    private Severity severity;
    private IRule rule;
    private String summary;
    private String explanation;
    private String solution;
    private Collection<IRecordingSetting> suggestedRecordingSettings;
    private Map<TypedResult<?>, Object> resultMap;
    private Map<TypedResult<?>, Collection<?>> collectionResultMap;
    private Map<TypedPreference<?>, Object> preferenceMap;

    public static ResultBuilder createFor(IRule rule, IPreferenceValueProvider preferenceProvider) {
        return new ResultBuilder(rule, preferenceProvider);
    }

    private ResultBuilder(IRule rule, IPreferenceValueProvider preferenceProvider) {
        this.rule = rule;
        this.suggestedRecordingSettings = new HashSet<IRecordingSetting>();
        this.resultMap = new HashMap();
        this.collectionResultMap = new HashMap();
        this.preferenceMap = new HashMap();
        for (TypedPreference<?> typedPreference : rule.getConfigurationAttributes()) {
            this.preferenceMap.put(typedPreference, preferenceProvider.getPreferenceValue(typedPreference));
        }
    }

    public ResultBuilder setSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public ResultBuilder setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public ResultBuilder setExplanation(String explanation) {
        this.explanation = explanation;
        return this;
    }

    public ResultBuilder setSolution(String solution) {
        this.solution = solution;
        return this;
    }

    public ResultBuilder setSuggestedRecordingSettings(Collection<IRecordingSetting> settings) {
        this.suggestedRecordingSettings = settings;
        return this;
    }

    public <T> ResultBuilder addResult(TypedCollectionResult<T> type, Collection<T> results) {
        this.collectionResultMap.put(type, results);
        return this;
    }

    public <T> ResultBuilder addResult(TypedResult<T> type, T result) {
        this.resultMap.put(type, result);
        return this;
    }

    public IResult build() {
        return new Result(this.severity, this.rule, this.summary, this.explanation, this.solution, this.suggestedRecordingSettings, this.resultMap, this.collectionResultMap, this.preferenceMap);
    }

    private static class Result
    implements IResult {
        private final Severity severity;
        private final IRule rule;
        private final String summary;
        private final String explanation;
        private final String solution;
        private final Collection<IRecordingSetting> suggestedRecordingSettings;
        private final Map<TypedResult<?>, Object> resultMap;
        private final Map<TypedResult<?>, Collection<?>> collectionResultMap;
        private final Map<TypedPreference<?>, Object> preferenceMap;

        Result(Severity severity, IRule rule, String summary, String explanation, String solution, Collection<IRecordingSetting> suggestedRecordingSettings, Map<TypedResult<?>, Object> resultMap, Map<TypedResult<?>, Collection<?>> collectionResultMap, Map<TypedPreference<?>, Object> preferenceMap) {
            this.severity = severity == null ? Severity.NA : severity;
            this.rule = rule;
            this.summary = summary;
            this.explanation = explanation;
            this.solution = solution;
            this.suggestedRecordingSettings = Collections.unmodifiableCollection(suggestedRecordingSettings);
            this.resultMap = Collections.unmodifiableMap(resultMap);
            this.collectionResultMap = Collections.unmodifiableMap(collectionResultMap);
            this.preferenceMap = Collections.unmodifiableMap(preferenceMap);
        }

        @Override
        public Severity getSeverity() {
            return this.severity;
        }

        @Override
        public IRule getRule() {
            return this.rule;
        }

        @Override
        public String getSummary() {
            return this.summary;
        }

        @Override
        public String getExplanation() {
            return this.explanation;
        }

        @Override
        public String getSolution() {
            return this.solution;
        }

        @Override
        public Collection<IRecordingSetting> suggestRecordingSettings() {
            return this.suggestedRecordingSettings;
        }

        @Override
        public <T> T getResult(TypedResult<T> key) {
            Object result = this.resultMap.get(key);
            if (key.getResultClass() == null) {
                return (T)result;
            }
            return key.getResultClass().cast(result);
        }

        @Override
        public <T> Collection<T> getResult(TypedCollectionResult<T> key) {
            Collection<?> collection = this.collectionResultMap.get(key);
            if (collection != null) {
                ArrayList results = new ArrayList(collection.size());
                for (Object object : collection) {
                    results.add(key.getResultClass().cast(object));
                }
                return Collections.unmodifiableCollection(results);
            }
            return Collections.emptyList();
        }

        @Override
        public <T> T getPreference(TypedPreference<T> preference) {
            return (T)this.preferenceMap.get(preference);
        }
    }
}

